/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.pdv.versaopaf;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.commons.modulo.intelidata.regranegocio.VersaoPafEstadoRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/versoes-paf-estado"})
@SubMenuMapping(MENU="SubMenuPortalCanalGeral", ICONE="icon-html", NOME="Vers\u00f5es do PAF por estado", ROTA="/intelidata/versoes-paf-estado", PROGRAMA=9000008)
public class VersaoPafEstadoCrudController
extends CrudController<Estado, EstadoRN> {
    public VersaoPafEstadoCrudController() {
        super((AbstractRegraNegocio)EstadoRN.getInstance(), Estado::new);
    }

    protected String getCacheId() {
        return "versoes-paf-estado";
    }

    protected GridBuilder<EstadoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, true));
        colunas.add(new ColunaSQL("nome", "Descri\u00e7\u00e3o", 0, true));
        GridBuilder grid = new GridBuilder(((EstadoRN)this.rn).getTabela(), colunas);
        grid.addOrdem(new Ordem("codigo"));
        return grid;
    }

    protected void beforeRead(Estado estado, int modo, Optional<Long> parentId) {
        estado.setVersoesPafEstado(VersaoPafEstadoRN.getInstance().buscarListPorIdEstado(estado.getId()));
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody Estado estado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        this.validarCurrentTimeMillis((AbstractPojo)estado);
        this.gravarAuditoriaRegistro(estado.getId(), (AbstractPojo)estado, 1);
        VersaoPafEstadoRN.getInstance().gravar(SessaoUtil.getSessao(), estado.getId(), estado.getVersoesPafEstado());
        this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
        return estado.getId();
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody Estado estado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW232", "Opera\u00e7\u00e3o n\u00e3o permitida");
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW233", "Opera\u00e7\u00e3o n\u00e3o permitida");
    }
}

