/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.compras.listagempedidocompras;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.compras.relatorio.PedidoCompraRelatorio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.compras.listagempedidocompras.ListagemPedidoCompraReport;

public class ListagemPedidoCompraReportExecute
extends AbstractReporteExecute<ListagemPedidoCompraReport> {
    public ListagemPedidoCompraReportExecute(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        ListagemPedidoCompraReport parametros = (ListagemPedidoCompraReport)this.fromJson(parametrosObj, ListagemPedidoCompraReport.class);
        return this.executa(sessao, parametros);
    }

    public Remessa executa(Sessao sessao, ListagemPedidoCompraReport report) throws UnicoMensagemUsuarioException {
        Entidade comprador = null;
        if (!Util.longNullOuZero((Long)report.getIdComprador())) {
            comprador = (Entidade)EntidadeRN.getInstance().buscarPorId(report.getIdComprador());
        }
        Entidade fornecedor = null;
        if (!Util.longNullOuZero((Long)report.getIdFornecedor())) {
            fornecedor = (Entidade)EntidadeRN.getInstance().buscarPorId(report.getIdFornecedor());
        }
        Produto produto = null;
        if (!Util.longNullOuZero((Long)report.getIdProduto())) {
            produto = (Produto)ProdutoRN.getInstance().buscarPorId(report.getIdProduto());
        }
        return new PedidoCompraRelatorio().getRelatorio(report.getSaida(), report.getFiliais(), report.getPeriodoInicial(), report.getPeriodoFinal(), report.getPeriodoEntregaInicial(), report.getPeriodoEntregaFinal(), comprador, fornecedor, produto, report.getFiltroStatus(), report.getAgrupamento(), report.isCheckItens(), report.getIdGrupoProduto(), report.getOrdenacao(), report.getTipoRelatorio());
    }
}

