/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.estoque.analisecalculocusto;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.custo.relatorio.CustoMedioDiarioRelatorio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.estoque.analisecalculocusto.AnaliseCalculoDeCusto;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public class AnaliseCalculoDeCustoReportExecuter
extends AbstractReporteExecute<AnaliseCalculoDeCusto> {
    public AnaliseCalculoDeCustoReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        AnaliseCalculoDeCusto analiseCalculoDeCusto = (AnaliseCalculoDeCusto)this.fromJson(parametrosObj, AnaliseCalculoDeCusto.class);
        return this.executa(sessao, analiseCalculoDeCusto);
    }

    public Remessa executa(Sessao sessao, AnaliseCalculoDeCusto parametros) throws UnicoMensagemUsuarioException {
        LocalDate dataFinal;
        LocalDate dataInicial = parametros.getInicio();
        LocalDate localDate = parametros.isPorData() ? dataInicial : (dataFinal = parametros.getFim() != null ? parametros.getFim() : DataHoraFactory.getData());
        if (dataInicial == null) {
            throw new UnicoMensagemUsuarioException("WCST30", parametros.isPorData() ? "Por favor escolha a data" : "Por favor escolha a data inicial");
        }
        if (parametros.isPorPeriodo() && !dataFinal.isBefore(DataHoraFactory.getData().plusDays(1L))) {
            throw new UnicoMensagemUsuarioException("WCST31", "A data final n\u00e3o pode ser maior que hoje");
        }
        if (ChronoUnit.DAYS.between(dataInicial, dataFinal) > 30L) {
            throw new UnicoMensagemUsuarioException("WCST56", "N\u00e3o \u00e9 poss\u00edvel realizar o c\u00e1lculo para uma diferen\u00e7a maior que 30 dias.");
        }
        if (parametros.isPorPeriodo() && Util.longNullOuZero((Long)parametros.getIdProduto())) {
            throw new UnicoMensagemUsuarioException("WCST57", "Por favor informe o produto");
        }
        Entidade fornecedor = null;
        if (!Util.longNullOuZero((Long)parametros.getIdFornecedor())) {
            fornecedor = (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdFornecedor());
        }
        Produto produto = null;
        if (!Util.longNullOuZero((Long)parametros.getIdProduto())) {
            produto = (Produto)ProdutoRN.getInstance().buscarPorId(parametros.getIdProduto());
        }
        return new CustoMedioDiarioRelatorio().getRelatorio(parametros.getSaida(), ((Filial)parametros.getFiliais().get(0)).getId(), fornecedor, produto, parametros.getIdHierarquiaProduto(), dataInicial, dataFinal);
    }
}

