/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.etiqueta.emissaoetiquetas;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.TrataImagemWeb;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.modulo.cadastros.regranegocio.PreferenciaUsuarioRN;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaModel;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaProduto;
import br.intelidata.commons.modulo.etiqueta.regranegocio.ModeloEtiquetaRN;
import br.intelidata.commons.modulo.etiqueta.relatorio.EtiquetaDriverNativoRelatorio;
import br.intelidata.commons.modulo.etiqueta.relatorio.EtiquetaJasperRelatorio;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.CondicaoPagamentoRN;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.report.etiqueta.emissaoetiquetas.EmissaoEtiqueta;
import java.util.HashMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class EmissaoEtiquetaReport {
    public static Remessa executa(Sessao sessao, EmissaoEtiqueta emissaoEtiquetaWrapper, TrataImagemWeb trataImagemWeb) throws UnicoMensagemUsuarioException {
        Map parametros = EmissaoEtiquetaReport.montarParametros((Long)emissaoEtiquetaWrapper.getPautaPreco(), (Long)emissaoEtiquetaWrapper.getIdCondicaoPagamento());
        int linhaInicial = emissaoEtiquetaWrapper.getLinhaInicial();
        int colunaInicial = emissaoEtiquetaWrapper.getColunaInicial();
        ModeloEtiquetaProduto modelo = new ModeloEtiquetaProduto();
        modelo.setTrataImagemWeb(trataImagemWeb);
        modelo.setModeloEtiqueta(ModeloEtiquetaRN.getInstance().buscarPorId(emissaoEtiquetaWrapper.getIdModeloEtiqueta(), true));
        emissaoEtiquetaWrapper.getEtiquetas().forEach(etiqueta -> {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(etiqueta.getIdProduto());
            if (etiqueta.getProdutoDTO() != null) {
                produto.setNome(etiqueta.getProdutoDTO().getNome());
                produto.setEmbalagem(etiqueta.getProdutoDTO().getEmbalagem());
            }
            etiqueta.setProduto(produto);
        });
        modelo.setEtiquetas(emissaoEtiquetaWrapper.getEtiquetas());
        modelo.getModeloEtiqueta().setGerarEmPdf(true);
        Remessa remessa = !StringUtil.stringNullOrEmpty((String)modelo.getModeloEtiqueta().getScriptEtiqueta()) ? EtiquetaDriverNativoRelatorio.getInstance().getRelatorio(sessao, (ModeloEtiquetaModel)modelo, parametros) : new EtiquetaJasperRelatorio().getRelatorio(sessao, (ModeloEtiquetaModel)modelo, parametros, linhaInicial, colunaInicial);
        EmissaoEtiquetaReport.alterarPreferencais((Sessao)sessao, (ModeloEtiquetaProduto)modelo);
        return remessa;
    }

    private static void alterarPreferencais(Sessao sessao, ModeloEtiquetaProduto modelo) throws UnicoMensagemUsuarioException {
        sessao.getUsuario().getPreferenciaUsuario().setIdUltimoModeloEtiquetaProduto(modelo.getModeloEtiqueta().getId());
        if (!Util.longNullOuZero((Long)sessao.getUsuario().getPreferenciaUsuario().getId())) {
            PreferenciaUsuarioRN.getInstance().alterar((AbstractPojo)sessao.getUsuario().getPreferenciaUsuario(), Contexto.getInstance().getSessao());
        } else {
            PreferenciaUsuarioRN.getInstance().incluir((AbstractPojo)sessao.getUsuario().getPreferenciaUsuario(), Contexto.getInstance().getSessao());
        }
        ProdutoRN.getInstance().atualizaDataEmissaoEtiqueta(sessao, null, modelo.getEtiquetas());
    }

    private static Map<String, Object> montarParametros(Long pautaPreco, Long idCondicaoPagamento) {
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("pautaPreco", pautaPreco);
        if (!NumberUtil.longNullOuZero((Long)idCondicaoPagamento)) {
            parametros.put("condicaoPagamento", CondicaoPagamentoRN.getInstance().buscarPorId(idCondicaoPagamento));
        }
        return parametros;
    }
}

