/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.etiqueta.emissaoetiquetas;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.TrataImagemWeb;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.CacheSistema;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AjusteEstoque;
import br.intelidata.commons.domain.pojo.AjusteEstoqueItem;
import br.intelidata.commons.domain.pojo.AjusteEstoqueItemLote;
import br.intelidata.commons.domain.pojo.ComponenteSaldoQuantidade;
import br.intelidata.commons.domain.pojo.Embalagem;
import br.intelidata.commons.domain.pojo.ModeloEtiquetaCampo;
import br.intelidata.commons.domain.pojo.NotaFiscalItemLote;
import br.intelidata.commons.domain.pojo.Precificado;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoConsulta;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoEan;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.Unidademedida;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoQuantidadeRegistroProducao;
import br.intelidata.commons.domain.pojo.enuns.TipoRegistroProduto;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalVariacao;
import br.intelidata.commons.domain.pojo.producao.RegistroProducaoItem;
import br.intelidata.commons.domain.pojo.producao.RegistroProducaoItemLote;
import br.intelidata.commons.domain.regranegocio.NotaFiscalItemLoteCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoEanCommonRN;
import br.intelidata.commons.domain.regranegocio.RegistroProducaoItemRN;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueItemRN;
import br.intelidata.commons.modulo.estoque.regranegocio.AjusteEstoqueRN;
import br.intelidata.commons.modulo.etiqueta.EtiquetaProduto;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaProduto;
import br.intelidata.commons.modulo.etiqueta.regranegocio.ModeloEtiquetaCampoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalVariacaoRN;
import br.intelidata.commons.modulo.preco.regranegocio.PrecificadoRN;
import br.intelidata.commons.modulo.preco.regranegocio.ProgramacaoAlteracaoPrecoItemRN;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.EtiquetaProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoConsultaRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.ProdutoItemInterface;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.rest.app.client.report.ReportController;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.report.etiqueta.emissaoetiquetas.EmissaoEtiqueta;
import br.intelidata.uniplusweb.web.rest.app.report.etiqueta.emissaoetiquetas.EmissaoEtiquetaEmLote;
import br.intelidata.uniplusweb.web.rest.app.report.etiqueta.emissaoetiquetas.EmissaoEtiquetaPorConsultaPreco;
import br.intelidata.uniplusweb.web.rest.app.report.etiqueta.emissaoetiquetas.EmissaoEtiquetaPrecificacao;
import br.intelidata.uniplusweb.web.rest.app.report.etiqueta.emissaoetiquetas.EmissaoEtiquetaReport;
import br.intelidata.uniplusweb.web.rest.app.report.etiqueta.emissaoetiquetas.EmissaoEtiquetaReportController;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Component(value="emissao-etiquetas")
@RequestMapping(value={"/jobs/emissao-etiquetas"})
@SubMenuMapping(MENU="SubMenuEstoqueRelatorio", NOME="Emiss\u00e3o de etiquetas", ICONE="icon-imprimir", ROTA="/reports-etiqueta/emissao-etiquetas", PROGRAMA=310)
public class EmissaoEtiquetaReportController
extends ReportController<EmissaoEtiqueta>
implements ProdutoItemInterface<EtiquetaProduto> {
    private static final String[] CAMPOS = new String[]{"produto.preco", "produto.precoPrazo", "produto.valorParcela", "produto.precocadastroparcelado", "produto.precobase"};
    private ModeloEtiquetaProduto model;
    @Autowired
    protected StorageService saveFile;

    public EmissaoEtiquetaReportController(ResponseEntityService responseService) {
        super(responseService);
    }

    @DBAutoCommit
    public ResponseEntity<byte[]> getReport(@RequestBody EmissaoEtiqueta emissaoEtiquetaWrapper) throws UnicoMensagemUsuarioException {
        1 trataImagemWeb = new /* Unavailable Anonymous Inner Class!! */;
        Remessa remessa = EmissaoEtiquetaReport.executa((Sessao)SessaoUtil.getSessao(), (EmissaoEtiqueta)emissaoEtiquetaWrapper, (TrataImagemWeb)trataImagemWeb);
        if (remessa.getMalote().contem("matricial")) {
            return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseService, (String)"Emiss\u00e3o de etiquetas");
        }
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseService, (SaidaRelatorio)emissaoEtiquetaWrapper.getSaidaRelatorio(), (String)"Emiss\u00e3o de etiquetas");
    }

    @RequestMapping(value={"/atualizar-precos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<EtiquetaProduto> atualizaCampoPreco(@RequestBody EmissaoEtiqueta etiqueta) {
        String campoPreco = this.getCampoPreco(etiqueta.getIdModeloEtiqueta());
        etiqueta.getEtiquetas().forEach(e -> this.getModelo().carregaPrecoProduto((Produto)ProdutoRN.getInstance().buscarPorId(e.getIdProduto()), e, campoPreco, etiqueta.getIdCondicaoPagamento(), etiqueta.getPautaPreco(), e.getPrecoFixo()));
        return etiqueta.getEtiquetas();
    }

    @RequestMapping(value={"/buscar-campos"})
    @DBAutoCommit
    public List<ModeloEtiquetaCampo> buscarCamposPorModeloEtiqueta(@RequestParam(value="idModeloEtiqueta") Long idModeloEtiqueta) {
        List campos = ModeloEtiquetaCampoRN.getInstance().buscarCamposPorModeloEtiqueta(idModeloEtiqueta);
        if (!ListMapUtil.listNullOrEmpty((List)campos)) {
            return campos.stream().filter(campo -> campo.getLinha() != 0 && campo.getColuna() != 0 && StringUtil.stringExistsIn((String)campo.getNomeCampo(), (String[])CAMPOS)).sorted(Comparator.comparing(ModeloEtiquetaCampo::getNomeCampo)).collect(Collectors.toList());
        }
        return null;
    }

    @RequestMapping(value={"/buscar-produtos-consultados"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ProdutoConsulta> buscarProdutosConsultados(@RequestBody EmissaoEtiquetaEmLote filtros) {
        if (filtros.getPeriodoInicial() == null) {
            filtros.setPeriodoInicial(DataHoraFactory.of((int)1900, (int)1, (int)1, (int)0, (int)0));
        }
        if (filtros.getPeriodoFinal() == null) {
            filtros.setPeriodoFinal(DataHoraFactory.of((int)3000, (int)1, (int)1, (int)0, (int)0));
        }
        return ProdutoConsultaRN.getInstance().buscarListaPorPeriodo(SessaoUtil.getSessao().getIdFilial(), filtros.getPeriodoInicial(), filtros.getPeriodoFinal(), filtros.getIdUsuario(), filtros.getTipoImpressao());
    }

    @RequestMapping(value={"/buscar-etiquetas-produtos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<EtiquetaProduto> buscarProdutosConsultados(@RequestBody EmissaoEtiquetaPorConsultaPreco emissaoEtiqueta) throws UnicoMensagemUsuarioException {
        if (emissaoEtiqueta.getProdutos() == null || emissaoEtiqueta.getProdutos().isEmpty()) {
            throw new UnicoMensagemUsuarioException("WWW669", "Selecione pelo menos um produto.");
        }
        ArrayList<EtiquetaProduto> etiquetas = new ArrayList<EtiquetaProduto>();
        for (ProdutoConsulta produtoConsulta : emissaoEtiqueta.getProdutos()) {
            ProdutoEan produtoEan;
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(produtoConsulta.getIdProduto());
            EtiquetaProduto etiquetaProduto = new EtiquetaProduto();
            etiquetaProduto.setProduto(produto);
            etiquetaProduto.setIdProduto(produto.getId());
            Unidademedida unidadeMedida = this.getUnidadeMedida((Object)produto.getIdUnidadeMedida());
            int casasDecimais = 0;
            if (unidadeMedida != null) {
                produto.setUnidadeMedida(unidadeMedida.getCodigo());
                casasDecimais = unidadeMedida.getCasasdecimais();
            }
            etiquetaProduto.setCasasDecimaisPeso(casasDecimais);
            BigDecimal quantidade = BigDecimal.ONE;
            if (emissaoEtiqueta.isQuantidadePeloEstoque() && casasDecimais == 0) {
                Sessao sessao = SessaoUtil.getSessao();
                quantidade = ProdutoRN.getInstance().getSaldoPrevistoEstoque(sessao, sessao.getIdFilial(), produto.getId());
                if (Util.bigDecimalNullOrZeroOrMenorZero((BigDecimal)quantidade)) {
                    quantidade = BigDecimal.ONE;
                }
            }
            etiquetaProduto.setQtdEtiquetas(quantidade);
            if (!Util.stringNullOrEmpty((String)produtoConsulta.getEanProduto()) && (produtoEan = ProdutoEanCommonRN.getInstance().buscarPorEan(produtoConsulta.getEanProduto())) != null && !Util.intNullOuZero((Integer)produtoEan.getVariacao())) {
                HashMap<Integer, Integer> variacoes = new HashMap<Integer, Integer>();
                variacoes.put(produtoEan.getVariacao(), 1);
                etiquetaProduto.setVariacoes(variacoes);
            }
            this.getModelo().carregaPrecoProduto(produto, etiquetaProduto, this.getCampoPreco(emissaoEtiqueta.getIdModeloEtiqueta()), emissaoEtiqueta.getIdFormaPaga(), emissaoEtiqueta.getIdPautaPreco(), null);
            etiquetaProduto.setProduto(null);
            etiquetaProduto.setProdutoDTO(ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), produto.getId()));
            etiquetas.add(etiquetaProduto);
        }
        return etiquetas;
    }

    @RequestMapping(value={"/atualiza-preco-produto"})
    @DBAutoCommit
    public EtiquetaProduto retornaProdutoEtiqueta(@RequestParam(value="idModeloEtiqueta") Long idModeloEtiqueta, @RequestParam(value="idCondicaoPagamento", required=false) Long idCondicaoPagamento, @RequestParam(value="idPauta") Long idPautaPreco, @RequestParam(value="idProduto") Long idProduto, @RequestParam(required=false) Long idEmbalagem) throws UnicoMensagemUsuarioException {
        EtiquetaProduto etiqueta = null;
        if (!NumberUtil.longNullOuZero((Long)idProduto) && !NumberUtil.longNullOuZero((Long)idModeloEtiqueta)) {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
            if (!NumberUtil.longNullOuZero((Long)idEmbalagem)) {
                Embalagem embalagem = (Embalagem)EmbalagemRN.getInstance().buscarPorId(idEmbalagem);
                produto.setEmbalagem(embalagem);
            }
            etiqueta = this.carregarProduto(produto, idModeloEtiqueta, idCondicaoPagamento, idPautaPreco, false);
        }
        return etiqueta;
    }

    @RequestMapping(value={"/gerar-em-lote"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<EtiquetaProduto> gerarEtiquetasEmLote(@RequestBody EmissaoEtiquetaEmLote filtros) throws UnicoMensagemUsuarioException {
        ArrayList<EtiquetaProduto> etiquetaProdutoList = new ArrayList<EtiquetaProduto>();
        List<Object> produtos = new ArrayList();
        if (!NumberUtil.longNullOuZero((Long)filtros.getIdGrupoProduto())) {
            produtos = ProdutoRN.getInstance().buscarListaPorGrupo(filtros.getIdGrupoProduto()).stream().filter(produto -> this.isIncluirProduto(produto) && !VariacaoRN.getInstance().isProdutoPossuiVariacaoAtiva(produto.getId())).collect(Collectors.toList());
        } else if (!NumberUtil.longNullOuZero((Long)filtros.getIdFamiliaProduto())) {
            produtos = ProdutoRN.getInstance().buscaListaPorFamilia(filtros.getIdFamiliaProduto()).stream().filter(produto -> this.isIncluirProduto(produto) && !VariacaoRN.getInstance().isProdutoPossuiVariacaoAtiva(produto.getId())).collect(Collectors.toList());
        } else if (!NumberUtil.longNullOuZero((Long)filtros.getIdPromocao())) {
            produtos = PromocaoRN.getInstance().buscaListaProdutosDaPromocao(PromocaoRN.getInstance().buscarPorId(filtros.getIdPromocao()), SessaoUtil.getSessao().getFilial().getId());
        } else if (!StringUtil.stringNullOrEmpty((String)filtros.getTipoDataAlteracaoPreco())) {
            boolean porData = filtros.getTipoDataAlteracaoPreco().equals("PERIODO");
            Long l = filtros.getIdPautaPreco();
            produtos = ProdutoRN.getInstance().buscarProdutosComAlteracaoPreco(SessaoUtil.getSessao(), l, porData ? filtros.getPeriodoInicial() : null, porData ? filtros.getPeriodoFinal() : null);
            produtos.removeIf(produto -> VariacaoRN.getInstance().isProdutoPossuiVariacaoAtiva(produto.getId()));
            if (porData && ListMapUtil.listNullOrEmpty(produtos)) {
                throw new UnicoMensagemUsuarioException("WEST48", "Nenhum produto encontrado dentro do per\u00edodo informado.");
            }
        }
        for (Produto produto2 : produtos) {
            EtiquetaProduto etiqueta = this.carregarProduto(produto2, filtros.getIdModeloEtiqueta(), filtros.getIdFormaPaga(), filtros.getIdPautaPreco(), filtros.isQuantidadePeloEstoque());
            etiqueta.setProduto(null);
            etiqueta.setIdProduto(produto2.getId());
            etiqueta.setProdutoDTO(ProdutoRN.getInstance().buscarProdutoDTOWeb(SessaoUtil.getSessao(), produto2.getId()));
            etiquetaProdutoList.add(etiqueta);
        }
        return etiquetaProdutoList;
    }

    @RequestMapping(value={"/importar-precificacoes"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<EtiquetaProduto> importarDadosPrecificacao(@RequestBody EmissaoEtiquetaPrecificacao emissaoEtiquetaPrecificacao) throws UnicoMensagemUsuarioException {
        ArrayList<EtiquetaProduto> etiquetas = new ArrayList<EtiquetaProduto>();
        List listaPrecificado = !ListMapUtil.listNullOrEmpty((List)emissaoEtiquetaPrecificacao.getPrecificados()) ? emissaoEtiquetaPrecificacao.getPrecificados() : PrecificadoRN.getInstance().getDadosEtiqueta(emissaoEtiquetaPrecificacao.getIds());
        if (!ListMapUtil.listNullOrEmpty((List)listaPrecificado)) {
            for (Precificado precificado : listaPrecificado) {
                if (precificado.getOrigem() == 2) {
                    Map mapDadosItem = NotaFiscalItemRN.getInstance().buscarValoresPorID(precificado.getIdNotaFiscalItem(), new String[]{"tipo", "idproduto", "idembalagem", "idunidademedida", "quantidade", "idnotafiscal"});
                    Map mapDadosNota = NotaFiscalRN.getInstance().buscarValoresPorID((Long)mapDadosItem.get("idnotafiscal"), new String[]{"numeronotafiscal", "modelo"});
                    this.carregarNotaFiscalItem(etiquetas, (String)mapDadosNota.get("numeronotafiscal"), (String)mapDadosNota.get("modelo"), precificado.getIdNotaFiscalItem(), precificado.getPrecoNovo(), null, Long.valueOf(0L), (Long)mapDadosItem.get("idproduto"), (Long)mapDadosItem.get("idembalagem"), (Long)mapDadosItem.get("idunidade"), (BigDecimal)mapDadosItem.get("quantidade"), (String)mapDadosItem.get("tipo"));
                    continue;
                }
                Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(precificado.getIdProduto());
                ProdutoDTOWeb produtoDTO = new ProdutoDTOWeb();
                BeanUtil.copiarValores((Object)produto, (Object)produtoDTO, (boolean)false, null);
                EtiquetaProduto etiquetaProduto = this.carregarProduto(produto, null, null, Long.valueOf(0L), precificado.getPrecoNovo(), false, false);
                etiquetaProduto.setPrecoFixo(precificado.getPrecoNovo());
                etiquetaProduto.setProdutoDTO(produtoDTO);
                etiquetas.add(etiquetaProduto);
            }
        }
        return EtiquetaProdutoRN.getInstance().agrupaEtiquetas(SessaoUtil.getSessao(), etiquetas);
    }

    @RequestMapping(value={"/importar-registro-producao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<EtiquetaProduto> importarDadosRegistroProducao(@RequestBody EmissaoEtiquetaPrecificacao emissaoEtiquetaPrecificacao) throws UnicoMensagemUsuarioException {
        ArrayList idsRegistroProducaoItem = new ArrayList();
        for (Long idRegistroProducao : emissaoEtiquetaPrecificacao.getIds()) {
            idsRegistroProducaoItem.addAll(RegistroProducaoItemRN.getInstance().buscaListaItensPorRegistroProducao(idRegistroProducao).stream().map(RegistroProducaoItem::getId).collect(Collectors.toList()));
        }
        emissaoEtiquetaPrecificacao.setIds(idsRegistroProducaoItem);
        return this.importarDadosRegistroProducaoItens(emissaoEtiquetaPrecificacao);
    }

    @RequestMapping(value={"/importar-programacao-preco"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<EtiquetaProduto> importarDadosProgramacaoPreco(@RequestBody EmissaoEtiquetaPrecificacao emissaoEtiquetaPrecificacao) {
        List itens = ProgramacaoAlteracaoPrecoItemRN.getInstance().buscarListaPorIdProgramacao((Long)emissaoEtiquetaPrecificacao.getIds().get(0));
        List etiquetas = EtiquetaProdutoRN.getInstance().carregaItens(SessaoUtil.getSessao(), itens, emissaoEtiquetaPrecificacao.isImprimirPrecoProduto());
        for (EtiquetaProduto etiqueta : etiquetas) {
            ProdutoDTOWeb produtoDTO = new ProdutoDTOWeb();
            BeanUtil.copiarValores((Object)etiqueta.getProduto(), (Object)produtoDTO, (boolean)false, null);
            etiqueta.setProdutoDTO(produtoDTO);
        }
        return etiquetas;
    }

    /*
     * WARNING - void declaration
     */
    @RequestMapping(value={"/importar-itens-registro-producao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<EtiquetaProduto> importarDadosRegistroProducaoItens(@RequestBody EmissaoEtiquetaPrecificacao emissaoEtiquetaPrecificacao) throws UnicoMensagemUsuarioException {
        List<Object> etiquetas = new ArrayList<EtiquetaProduto>();
        List itens = RegistroProducaoItemRN.getInstance().buscarListaPorIds(emissaoEtiquetaPrecificacao.getIds());
        TreeMap<String, EtiquetaProduto> mapEtiquetaProduto = new TreeMap<String, EtiquetaProduto>();
        List listaItemSemLotes = itens.stream().filter(item -> Util.listNullOrEmpty((List)item.getLotes())).collect(Collectors.toList());
        for (RegistroProducaoItem item2 : listaItemSemLotes) {
            void var8_8;
            RegistroProducaoItemRN.getInstance().carregarDadosItemRegistroProducao(SessaoUtil.getSessao(), item2, true, null, false);
            EtiquetaProduto etiquetaProduto = (EtiquetaProduto)mapEtiquetaProduto.get(item2.getIdProduto().toString());
            if (etiquetaProduto == null) {
                Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(item2.getIdProduto());
                Unidademedida unidademedida = CacheSistema.getInstance().getUnidadeMedida(produto.getIdUnidadeMedida());
                if (unidademedida != null) {
                    produto.setUnidadeMedida(unidademedida.getCodigo());
                }
                EtiquetaProduto etiquetaProduto2 = this.carregarProduto(produto, null, null, Long.valueOf(0L), BigDecimal.ZERO, false, false);
                etiquetaProduto2.setQtdEtiquetas(BigDecimal.ZERO);
                mapEtiquetaProduto.put(produto.getId().toString(), etiquetaProduto2);
            }
            var8_8.setQtdEtiquetas(var8_8.getQtdEtiquetas().add(item2.getQuantidadeAjustada()));
        }
        List listaItemComLotes = itens.stream().filter(item -> !Util.listNullOrEmpty((List)item.getLotes())).collect(Collectors.toList());
        for (RegistroProducaoItem registroProducaoItem : listaItemComLotes) {
            RegistroProducaoItemRN.getInstance().carregarDadosItemRegistroProducao(SessaoUtil.getSessao(), registroProducaoItem, true, null, false);
            List listaLotes = registroProducaoItem.getLotes();
            boolean pegarQuantidadeAjustada = listaLotes.size() == 1;
            for (RegistroProducaoItemLote lote : listaLotes) {
                String chave = registroProducaoItem.getIdProduto().toString().concat("_").concat(lote.getIdLote().toString());
                EtiquetaProduto etiquetaProduto = (EtiquetaProduto)mapEtiquetaProduto.get(chave);
                if (etiquetaProduto == null) {
                    Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(registroProducaoItem.getIdProduto());
                    Unidademedida unidademedida = CacheSistema.getInstance().getUnidadeMedida(produto.getIdUnidadeMedida());
                    if (unidademedida != null) {
                        produto.setUnidadeMedida(unidademedida.getCodigo());
                    }
                    etiquetaProduto = this.carregarProduto(produto, null, null, Long.valueOf(0L), BigDecimal.ZERO, false, false);
                    etiquetaProduto.setIdLote(lote.getIdLote());
                    mapEtiquetaProduto.put(chave, etiquetaProduto);
                }
                if (pegarQuantidadeAjustada) {
                    etiquetaProduto.setQtdEtiquetas(etiquetaProduto.getQtdEtiquetas().add(registroProducaoItem.getQuantidadeAjustada()));
                    continue;
                }
                if (TipoQuantidadeRegistroProducao.NUMERO_RECEITAS.equals((Object)registroProducaoItem.getTipoQuantidade())) {
                    etiquetaProduto.setQtdEtiquetas(etiquetaProduto.getQtdEtiquetas().add(lote.getQuantidade().multiply(registroProducaoItem.getQuantidadePadrao())));
                    continue;
                }
                etiquetaProduto.setQtdEtiquetas(etiquetaProduto.getQtdEtiquetas().add(lote.getQuantidade()));
            }
        }
        if (!Util.mapNullOrEmpty(mapEtiquetaProduto)) {
            etiquetas = new ArrayList(mapEtiquetaProduto.values());
            for (EtiquetaProduto etiquetaProduto : etiquetas) {
                Unidademedida unidademedida = CacheSistema.getInstance().getUnidadeMedida(etiquetaProduto.getProduto().getIdUnidadeMedida());
                etiquetaProduto.setQtdEtiquetas(etiquetaProduto.getQtdEtiquetas().setScale((int)unidademedida.getCasasdecimais(), RoundingMode.HALF_EVEN));
                ProdutoDTOWeb produtoDTO = new ProdutoDTOWeb();
                BeanUtil.copiarValores((Object)etiquetaProduto.getProduto(), (Object)produtoDTO, (boolean)false, null);
                etiquetaProduto.setProdutoDTO(produtoDTO);
            }
            etiquetas = EtiquetaProdutoRN.getInstance().agrupaEtiquetas(SessaoUtil.getSessao(), etiquetas);
            etiquetas.sort(Comparator.comparing(e -> e.getProduto().getDescricao()));
        }
        return etiquetas;
    }

    @RequestMapping(value={"/importar-itens-nota"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<EtiquetaProduto> importarItensNota(@RequestBody List<NotaFiscalItem> itens) {
        ArrayList etiquetas = new ArrayList();
        Map mapDadosNota = NotaFiscalRN.getInstance().buscarValoresPorID(itens.get(0).getIdnotafiscal(), new String[]{"numeronotafiscal", "modelo"});
        itens.forEach(item -> this.carregarNotaFiscalItem(etiquetas, (String)mapDadosNota.get("numeronotafiscal"), (String)mapDadosNota.get("modelo"), item.getId(), null, null, Long.valueOf(0L), item.getIdProduto(), item.getIdEmbalagem(), item.getIdUnidadeMedida(), item.getQuantidade(), item.getTipo()));
        return EtiquetaProdutoRN.getInstance().agrupaEtiquetas(SessaoUtil.getSessao(), etiquetas);
    }

    @RequestMapping(value={"/importar-itens-ajuste-estoque"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<EtiquetaProduto> importarItensEstoque(@RequestBody Long idAjusteEstoque) {
        ArrayList etiquetas = new ArrayList();
        ModeloEtiquetaProduto model = new ModeloEtiquetaProduto();
        AjusteEstoque ajusteEstoque = (AjusteEstoque)AjusteEstoqueRN.getInstance().buscarPorId(idAjusteEstoque);
        List itens = AjusteEstoqueItemRN.getInstance().buscarListaPorIdAjusteEstoque(idAjusteEstoque);
        this.carregaItensAjusteEstoque(etiquetas, itens, model, ajusteEstoque.isContagem());
        return EtiquetaProdutoRN.getInstance().agrupaEtiquetas(SessaoUtil.getSessao(), etiquetas);
    }

    private String getCampoPreco(@RequestParam(value="idModeloEtiqueta") Long idModeloEtiqueta) {
        ArrayList campos = idModeloEtiqueta != null ? ModeloEtiquetaCampoRN.getInstance().buscaCampos(idModeloEtiqueta, this.getModelo().getCamposConfigPreco()) : new ArrayList();
        return this.getModelo().getCampoPreco(campos);
    }

    private boolean isIncluirProduto(Produto produto) {
        boolean permiteInativo = PropriedadeRN.getInstance().getPropriedadeBoolean(Contexto.getInstance().getFilial(), 91);
        return permiteInativo || !produto.isInativo();
    }

    private Unidademedida getUnidadeMedida(Object id) {
        Unidademedida unidade = id instanceof String ? UnidademedidaRN.getInstance().buscarPorCodigo((String)id) : (Unidademedida)UnidademedidaRN.getInstance().buscarPorId((Long)id);
        return unidade;
    }

    private ModeloEtiquetaProduto getModelo() {
        if (this.model == null) {
            this.model = new ModeloEtiquetaProduto();
        }
        return this.model;
    }

    private EtiquetaProduto carregarProduto(Produto produto, Long idModeloEtiqueta, Long idCondicaoPagamento, Long indexPautaPreco, boolean quantidadePeloEstoque) throws UnicoMensagemUsuarioException {
        return this.carregarProduto(produto, idModeloEtiqueta, idCondicaoPagamento, indexPautaPreco, BigDecimal.ZERO, true, quantidadePeloEstoque);
    }

    private EtiquetaProduto carregarProduto(Produto produto, Long idModeloEtiqueta, Long idCondicaoPagamento, Long indexPautaPreco, BigDecimal preco, boolean validar, boolean quantidadePeloEstoque) throws UnicoMensagemUsuarioException {
        if (validar) {
            if (NumberUtil.longNullOuZero((Long)idModeloEtiqueta)) {
                throw new UnicoMensagemUsuarioException("WETQ55", "Por favor selecione o modelo.");
            }
            if (!this.isIncluirProduto(produto)) {
                throw new UnicoMensagemUsuarioException("WETQ60", "O produto " + produto.getNome() + " n\u00e3o pode ser selecionado porque est\u00e1 inativo");
            }
        }
        EtiquetaProduto etiquetaProduto = new EtiquetaProduto();
        etiquetaProduto.setIdProduto(produto.getId());
        etiquetaProduto.setProduto(produto);
        Unidademedida unidadeMedida = this.getUnidadeMedida((Object)produto.getIdUnidadeMedida());
        int casasDecimais = 0;
        if (unidadeMedida != null) {
            produto.setUnidadeMedida(unidadeMedida.getCodigo());
            casasDecimais = unidadeMedida.getCasasdecimais();
        }
        etiquetaProduto.setCasasDecimaisPeso(casasDecimais);
        etiquetaProduto.setVariacoes(null);
        BigDecimal quantidade = BigDecimal.ONE;
        if (quantidadePeloEstoque && casasDecimais == 0) {
            Sessao sessao = SessaoUtil.getSessao();
            quantidade = ProdutoRN.getInstance().getSaldoPrevistoEstoque(sessao, sessao.getIdFilial(), produto.getId());
            if (Util.bigDecimalNullOrZeroOrMenorZero((BigDecimal)quantidade)) {
                quantidade = BigDecimal.ONE;
            }
        }
        etiquetaProduto.setQtdEtiquetas(quantidade);
        String campoPreco = null;
        if (!NumberUtil.longNullOuZero((Long)idModeloEtiqueta)) {
            campoPreco = this.getCampoPreco(idModeloEtiqueta);
        }
        Sessao sessao = SessaoUtil.getSessao();
        if (!produto.getTipo().equals((Object)TipoRegistroProduto.PRODUTO) || produto.isKit()) {
            etiquetaProduto.setSaldo(BigDecimal.ZERO);
            etiquetaProduto.setSaldoPrevisto(BigDecimal.ZERO);
        } else {
            ComponenteSaldoQuantidade componenteSaldoQuantidade = ProdutoRN.getInstance().buscaSaldoQuantidadeComponente(sessao, sessao.getIdFilial(), etiquetaProduto.getProduto().getId(), null, null, false);
            etiquetaProduto.setSaldo(componenteSaldoQuantidade.getSaldoAtual());
            etiquetaProduto.setSaldoPrevisto(componenteSaldoQuantidade.getSaldoPrevisto());
        }
        produto.setPossuiVariacao(VariacaoRN.getInstance().isProdutoPossuiVariacaoAtiva(produto.getId()));
        this.getModelo().carregaPrecoProduto(produto, etiquetaProduto, campoPreco, idCondicaoPagamento, indexPautaPreco, preco);
        return etiquetaProduto;
    }

    private void carregarNotaFiscalItem(List<EtiquetaProduto> etiquetas, String numeroNotaFiscal, String modeloNota, Long idNotaFiscalItem, BigDecimal preco, Long idCondicaoPagamento, Long idPautaPreco, Long idProduto, Long idEmbalagem, Long idUnidade, BigDecimal quantidade, String tipo) {
        if (tipo.equalsIgnoreCase("P")) {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(idProduto);
            if (produto == null) {
                return;
            }
            ProdutoDTOWeb produtoDTO = new ProdutoDTOWeb();
            BeanUtil.copiarValores((Object)produto, (Object)produtoDTO, (boolean)false, null);
            int casasDecimais = 0;
            BigDecimal fatorConversao = BigDecimal.ONE;
            if (!Util.longNullOuZero((Long)idEmbalagem)) {
                Embalagem embalagem = (Embalagem)EmbalagemRN.getInstance().buscarPorId(idEmbalagem);
                if (embalagem != null) {
                    Unidademedida unidadeMedida = this.getUnidadeMedida((Object)produto.getIdUnidadeMedida());
                    if (unidadeMedida != null) {
                        produto.setUnidadeMedida(unidadeMedida.getCodigo());
                        casasDecimais = unidadeMedida.getCasasdecimais();
                    }
                    fatorConversao = embalagem.getFatorConversao();
                }
            } else {
                Unidademedida unidadeMedida = this.getUnidadeMedida((Object)idUnidade);
                if (unidadeMedida != null) {
                    produto.setUnidadeMedida(unidadeMedida.getCodigo());
                    casasDecimais = unidadeMedida.getCasasdecimais();
                }
            }
            List variacoes = NotaFiscalVariacaoRN.getInstance().buscarListaPorIdNotaFiscalItem(new Long[]{idNotaFiscalItem});
            HashMap<Integer, Integer> mapVariacoes = null;
            if (!Util.collectionNullOrEmpty((Collection)variacoes)) {
                mapVariacoes = new HashMap<Integer, Integer>(variacoes.size());
                for (NotaFiscalVariacao variacao : variacoes) {
                    mapVariacoes.put(variacao.getVariacao(), variacao.getQuantidade().intValue());
                }
            }
            if (produto.isPesavel()) {
                EtiquetaProduto etqProd = new EtiquetaProduto();
                etqProd.setNumeroNotaFiscal(numeroNotaFiscal + "-" + modeloNota);
                etqProd.setIdProduto(produto.getId());
                etqProd.setProduto(produto);
                etqProd.setProdutoDTO(produtoDTO);
                etqProd.setPrecoFixo(preco);
                etqProd.setQtdEtiquetas(BigDecimal.ONE);
                etqProd.setPeso(quantidade.setScale(casasDecimais, RoundingMode.HALF_DOWN));
                etqProd.setVariacoes(mapVariacoes);
                etqProd.setCasasDecimais(produto.getCasasDecimais().intValue());
                etqProd.setCasasDecimaisPeso(casasDecimais);
                this.getModelo().carregaPrecoProduto(produto, etqProd, numeroNotaFiscal, idCondicaoPagamento, idPautaPreco, preco);
                etiquetas.add(etqProd);
            } else {
                List lotes = NotaFiscalItemLoteCommonRN.getInstance().buscarPorIdNotaFiscalItem(idNotaFiscalItem);
                if (Util.listNullOrEmpty((List)lotes)) {
                    EtiquetaProduto etqProd = new EtiquetaProduto();
                    etqProd.setNumeroNotaFiscal(numeroNotaFiscal + "-" + modeloNota);
                    etqProd.setIdProduto(produto.getId());
                    etqProd.setProduto(produto);
                    etqProd.setProdutoDTO(produtoDTO);
                    etqProd.setPrecoFixo(preco);
                    etqProd.setVariacoes(mapVariacoes);
                    etqProd.setCasasDecimais(produto.getCasasDecimais().intValue());
                    this.setQuantidadeEtiqueta(etqProd, quantidade, casasDecimais, fatorConversao);
                    this.getModelo().carregaPrecoProduto(produto, etqProd, numeroNotaFiscal, idCondicaoPagamento, idPautaPreco, preco);
                    etiquetas.add(etqProd);
                } else {
                    for (NotaFiscalItemLote itemLote : lotes) {
                        EtiquetaProduto etqProd = new EtiquetaProduto();
                        etqProd.setNumeroNotaFiscal(numeroNotaFiscal + "-" + modeloNota);
                        etqProd.setIdProduto(produto.getId());
                        etqProd.setProduto(produto);
                        etqProd.setProdutoDTO(produtoDTO);
                        etqProd.setPrecoFixo(preco);
                        etqProd.setIdLote(itemLote.getIdLote());
                        etqProd.setVariacoes(mapVariacoes);
                        etqProd.setCasasDecimais(produto.getCasasDecimais().intValue());
                        this.setQuantidadeEtiqueta(etqProd, itemLote.getQuantidade(), casasDecimais, fatorConversao);
                        this.getModelo().carregaPrecoProduto(produto, etqProd, numeroNotaFiscal, idCondicaoPagamento, idPautaPreco, preco);
                        etiquetas.add(etqProd);
                    }
                }
            }
        }
    }

    private void carregaItensAjusteEstoque(List<EtiquetaProduto> etiquetas, List<AjusteEstoqueItem> itensAjusteEstoque, ModeloEtiquetaProduto modelo, boolean contagem) {
        if (itensAjusteEstoque == null) {
            return;
        }
        for (AjusteEstoqueItem ajusteEstoqueItem : itensAjusteEstoque) {
            Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(ajusteEstoqueItem.getIdProduto());
            if (produto == null || ajusteEstoqueItem.getQuantidade().compareTo(BigDecimal.ZERO) == 0 && contagem) continue;
            ProdutoDTOWeb produtoDTO = new ProdutoDTOWeb();
            BeanUtil.copiarValores((Object)produto, (Object)produtoDTO, (boolean)false, null);
            int casasDecimais = 0;
            BigDecimal fatorConversao = BigDecimal.ONE;
            Long idUnidadeMedida = ajusteEstoqueItem.getIdUnidadeMedida();
            if (idUnidadeMedida == null) {
                idUnidadeMedida = produto.getIdUnidadeMedida();
            }
            if (!produto.getIdUnidadeMedida().equals(idUnidadeMedida)) {
                Embalagem embalagem = EmbalagemRN.getInstance().buscarPorIdProdutoIdUnidadeTipo(produto.getId(), idUnidadeMedida, TipoEmbalagem.COMPRA);
                if (embalagem != null) {
                    Unidademedida unidadeMedida = this.getUnidadeMedida((Object)produto.getIdUnidadeMedida());
                    if (unidadeMedida != null) {
                        produto.setUnidadeMedida(unidadeMedida.getCodigo());
                        casasDecimais = unidadeMedida.getCasasdecimais();
                    }
                    fatorConversao = embalagem.getFatorConversao();
                }
            } else {
                Unidademedida unidadeMedida = this.getUnidadeMedida((Object)idUnidadeMedida);
                if (unidadeMedida != null) {
                    produto.setUnidadeMedida(unidadeMedida.getCodigo());
                    casasDecimais = unidadeMedida.getCasasdecimais();
                }
            }
            if (produto.isPesavel()) {
                BigDecimal quantidade = ajusteEstoqueItem.getQuantidade().setScale(casasDecimais, RoundingMode.HALF_DOWN);
                EtiquetaProduto etqProd = new EtiquetaProduto();
                etqProd.setIdProduto(produto.getId());
                etqProd.setProduto(produto);
                etqProd.setProdutoDTO(produtoDTO);
                etqProd.setQtdEtiquetas(BigDecimal.ONE);
                etqProd.setPeso(quantidade);
                etqProd.setVariacoes(ajusteEstoqueItem.getListaVariacoes());
                etqProd.setCasasDecimais(produto.getCasasDecimais().intValue());
                etqProd.setCasasDecimaisPeso(casasDecimais);
                modelo.carregaPrecoProduto(produto, etqProd, null, null, null, null);
                etiquetas.add(etqProd);
                continue;
            }
            if (Util.listNullOrEmpty((List)ajusteEstoqueItem.getLotes())) {
                EtiquetaProduto etqProd = new EtiquetaProduto();
                etqProd.setIdProduto(produto.getId());
                etqProd.setProduto(produto);
                etqProd.setProdutoDTO(produtoDTO);
                etqProd.setVariacoes(ajusteEstoqueItem.getListaVariacoes());
                etqProd.setCasasDecimais(produto.getCasasDecimais().intValue());
                this.setQuantidadeEtiqueta(etqProd, ajusteEstoqueItem.getQuantidade(), casasDecimais, fatorConversao);
                modelo.carregaPrecoProduto(produto, etqProd, null, null, null, null);
                etiquetas.add(etqProd);
                continue;
            }
            for (AjusteEstoqueItemLote itemLote : ajusteEstoqueItem.getLotes()) {
                EtiquetaProduto etqProd = new EtiquetaProduto();
                etqProd.setIdProduto(produto.getId());
                etqProd.setProduto(produto);
                etqProd.setProdutoDTO(produtoDTO);
                etqProd.setIdLote(itemLote.getIdLote());
                etqProd.setVariacoes(ajusteEstoqueItem.getListaVariacoes());
                etqProd.setCasasDecimais(produto.getCasasDecimais().intValue());
                this.setQuantidadeEtiqueta(etqProd, itemLote.getQuantidade(), casasDecimais, fatorConversao);
                modelo.carregaPrecoProduto(produto, etqProd, null, null, null, null);
                etiquetas.add(etqProd);
            }
        }
    }

    private void setQuantidadeEtiqueta(EtiquetaProduto etqProd, BigDecimal quantidade, int casasDecimais, BigDecimal fatorConversao) {
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 443)) {
            etqProd.setQtdEtiquetas(BigDecimal.ONE);
        } else if (casasDecimais == 0) {
            etqProd.setQtdEtiquetas(quantidade.multiply(fatorConversao).setScale(0, 5));
        } else {
            etqProd.setQtdEtiquetas(BigDecimal.ONE);
        }
    }

    public ProdutoItemWeb<EtiquetaProduto> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        Unidademedida unidadeMedida;
        ProdutoItemWeb produtoItem = new ProdutoItemWeb();
        produtoItem.setProduto(produto);
        if (produtoItem.getProduto().getEmbalagem() != null) {
            unidadeMedida = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(produtoItem.getProduto().getEmbalagem().getIdUnidadeMedida());
            produtoItem.setEmbalagens(Collections.singletonList(produto.getEmbalagem()));
            produtoItem.getProduto().setEan(produto.getEmbalagem().getCodigoBarras());
        } else {
            unidadeMedida = (Unidademedida)UnidademedidaRN.getInstance().buscarPorId(produtoItem.getProduto().getIdUnidadeMedida());
        }
        produtoItem.setUnidadeMedida(unidadeMedida);
        return produtoItem;
    }
}

