/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.financeiro.planocontas;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.HierarquiaPlanoContas;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.HierarquiaPlanoContasRN;
import br.intelidata.commons.modulo.financeiro.relatorio.PlanoContasRelatorio;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.planocontas.PlanoContas;
import java.util.List;
import java.util.stream.Collectors;

public class PlanoContasReportExecuter
extends AbstractReporteExecute<PlanoContas> {
    public PlanoContasReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        PlanoContas planoContas = (PlanoContas)this.fromJson(parametrosObj, PlanoContas.class);
        return this.executa(sessao, planoContas);
    }

    public Remessa executa(Sessao sessao, PlanoContas parametros) throws UnicoMensagemUsuarioException {
        List listaPlanoContas = null;
        if (!ListMapUtil.listNullOrEmpty((List)parametros.getIdsPlanoContas())) {
            listaPlanoContas = parametros.getIdsPlanoContas().stream().map(id -> (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(id)).collect(Collectors.toList());
        }
        Entidade cliente = parametros.getIdEntidade() != null ? (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdEntidade()) : null;
        return new PlanoContasRelatorio().getRelatorio(parametros.getSaida(), parametros.getFiliais(), parametros.getEmissaoInicial(), parametros.getEmissaoFinal(), parametros.getVencimentoInicial(), parametros.getVencimentoFinal(), parametros.getPagamentoInicial(), parametros.getPagamentoFinal(), listaPlanoContas, parametros.isMostraDetalhado(), parametros.isMostrarSubstituido(), parametros.isImprimirObservacao(), cliente, parametros.getIdBanco(), parametros.getIdPortador(), parametros.getReferenciaInicial(), parametros.getReferenciaFinal());
    }
}

