/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.unichef.vendasgourmet;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.client.report.Report;
import br.intelidata.uniplusweb.web.rest.app.report.unichef.vendasgourmet.VendasGourmet;
import br.intelidata.uniplusweb.web.rest.app.report.unichef.vendasgourmet.VendasGourmetReportExecuter;
import java.util.HashSet;
import java.util.Set;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import unichef.pojo.TipoIntegracaoUnichef;

@RestController
@RequestMapping(value={"/jobs/vendas-gourmet"})
@SubMenuMapping(MENU="SubMenuGourmetRelatorio", NOME="Vendas Gourmet", ICONE="icon-imprimir", ROTA="/reports-unichef/vendas-gourmet", PROGRAMA=550)
public class VendasGourmetReportController
extends Report<VendasGourmet> {
    public Class<? extends AbstractJob> job() {
        return VendasGourmetReportExecuter.class;
    }

    @RequestMapping(value={"/tipos-integracao"})
    @DBAutoCommit
    public Set<TipoIntegracaoUnichef> buscarTiposIntegracao() {
        HashSet<TipoIntegracaoUnichef> integracoesHabilitadas = new HashSet<TipoIntegracaoUnichef>();
        for (Filial filial : FilialRN.getInstance().buscarLista()) {
            if (filial.getParametroIntegracaoIfood().isHabilitadoIfood()) {
                integracoesHabilitadas.add(TipoIntegracaoUnichef.IFOOD);
            }
            if (filial.getParametrosIntegracaoAbrahao().isHabilitadoAbrahao()) {
                integracoesHabilitadas.add(TipoIntegracaoUnichef.ABRAHAO);
            }
            if (filial.getParametrosIntegracaoGoomer().isHabilitadoGoomer()) {
                integracoesHabilitadas.add(TipoIntegracaoUnichef.GOOMER);
            }
            if (!filial.getParametrosIntegracaoAnotaAI().isHabilitadoAnotaAI()) continue;
            integracoesHabilitadas.add(TipoIntegracaoUnichef.ANOTA_AI);
        }
        return integracoesHabilitadas;
    }
}

