/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.vendas.vendasprodutovariacao;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.produto.regranegocio.GradeValorRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.vendas.relatorio.VendasProdutoPorVariacao;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.vendas.vendasprodutovariacao.VendaProdutoVariacao;
import java.util.List;

public class VendaProdutoVariacaoReportExecute
extends AbstractReporteExecute<VendaProdutoVariacao> {
    public VendaProdutoVariacaoReportExecute(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        VendaProdutoVariacao vendaProdutoVariacao = (VendaProdutoVariacao)this.fromJson(parametrosObj, VendaProdutoVariacao.class);
        return this.executa(sessao, vendaProdutoVariacao);
    }

    public Remessa executa(Sessao sessao, VendaProdutoVariacao parametros) throws UnicoMensagemUsuarioException {
        Produto produto = null;
        Entidade vendedor = null;
        List linhas = null;
        List colunas = null;
        if (!NumberUtil.longNullOuZero((Long)parametros.getIdProduto())) {
            produto = (Produto)ProdutoRN.getInstance().buscarPorId(parametros.getIdProduto());
        }
        if (!NumberUtil.longNullOuZero((Long)parametros.getIdVendedor())) {
            vendedor = (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdVendedor());
        }
        if (!ListMapUtil.listNullOrEmpty((List)parametros.getLinhas())) {
            linhas = GradeValorRN.getInstance().buscaPorIds(parametros.getLinhas());
        }
        if (!ListMapUtil.listNullOrEmpty((List)parametros.getColunas())) {
            colunas = GradeValorRN.getInstance().buscaPorIds(parametros.getColunas());
        }
        return new VendasProdutoPorVariacao().getRelatorio(parametros.getSaida(), parametros.getFiliais(), parametros.getPeriodoInicial(), parametros.getPeriodoFinal(), vendedor, produto, linhas, colunas);
    }
}

