/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.atualizador.componentes;

import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.yoda.app.atualizador.componentes.YodaTableModelColuna;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class YodaTableModel<E>
extends AbstractTableModel {
    private YodaTableModelColuna[] colunas;
    private List<E> fonteDados;

    public YodaTableModel(Collection<YodaTableModelColuna> colecaoColunas) {
        this.colunas = new YodaTableModelColuna[colecaoColunas.size()];
        colecaoColunas.toArray(this.colunas);
    }

    public YodaTableModel(YodaTableModelColuna[] colunas) {
        this.colunas = colunas != null ? (YodaTableModelColuna[])colunas.clone() : null;
    }

    public YodaTableModelColuna[] getColunas() {
        return this.colunas != null ? (YodaTableModelColuna[])this.colunas.clone() : null;
    }

    @Override
    public int getColumnCount() {
        return this.colunas.length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.colunas[columnIndex].getEditor() != null;
    }

    @Override
    public String getColumnName(int column) {
        return this.colunas[column].getDescricao();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        YodaTableModelColuna coluna = this.colunas[columnIndex];
        if (coluna.getTipo() != null) {
            return coluna.getTipo();
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object result;
        if (this.getFonteDados().size() <= rowIndex) {
            return null;
        }
        YodaTableModelColuna coluna = this.colunas[columnIndex];
        if (!coluna.isBinding()) {
            return null;
        }
        Object objeto = this.getFonteDados().get(rowIndex);
        if (objeto instanceof Map) {
            result = coluna.getNome().equals("this") ? (Object)objeto : ((Map)objeto).get(coluna.getNome());
        } else {
            try {
                result = BeanUtil.get(objeto, (String)coluna.getNome(), (Object[])new Object[0]);
            }
            catch (Throwable ex) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        YodaTableModelColuna coluna = this.colunas[columnIndex];
        if (!coluna.isBinding()) {
            return;
        }
        Object objeto = this.getFonteDados().get(rowIndex);
        if (objeto instanceof Map) {
            ((Map)objeto).put(coluna.getNome(), aValue);
        } else {
            BeanUtil.set(objeto, (String)coluna.getNome(), (Object)aValue);
        }
    }

    @Override
    public int getRowCount() {
        return this.getFonteDados().size();
    }

    public <X> X getValor(int linha, String coluna) {
        Object objeto = this.getFonteDados().get(linha);
        if (!(objeto instanceof Map)) {
            throw new UnicoException("COM236565", "Este metodo s\u00f3 deve ser usado quando a fonte de dados for uma Lista de Map");
        }
        Object result = ((Map)objeto).get(coluna);
        return (X)result;
    }

    public List<E> getFonteDados() {
        if (this.isFonteDadosNull()) {
            this.fonteDados = new ArrayList();
        }
        return this.fonteDados;
    }

    public void setFonteDados(List<E> fonteDados) {
        this.fonteDados = fonteDados;
    }

    public E get(int index) {
        return this.getFonteDados().get(index);
    }

    public void set(int index, E e) {
        this.getFonteDados().set(index, e);
    }

    public void add(E e) {
        this.getFonteDados().add(e);
    }

    public void add(int index, E e) {
        if (index >= this.getFonteDados().size() || index == -1) {
            this.getFonteDados().add(e);
        } else {
            this.getFonteDados().add(index, e);
        }
    }

    public void addAll(Collection<E> colecao) {
        this.getFonteDados().addAll(colecao);
    }

    public void remove(int index) {
        this.getFonteDados().remove(index);
    }

    public void clear() {
        this.setFonteDados(null);
    }

    public boolean contains(E e) {
        return this.getFonteDados().contains(e);
    }

    protected boolean isFonteDadosNull() {
        return this.fonteDados == null;
    }
}

