/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch;

import br.intelidata.commons.bridge.Bridge;
import br.intelidata.commons.bridge.IBridgeConnectionScheduler;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.yoda.app.batch.YodaJob;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YodaJobExecutor {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final YodaJob job;
    private final Task task;
    private IConnectionHandler cnnHandler;

    public YodaJobExecutor(YodaJob job) {
        this.job = job;
        this.task = job.getTask();
        this.cnnHandler = job.getConnectionHandler();
    }

    public void executar() {
        try {
            this.log.debug("In\u00edcio da tarefa {},{}", (Object)this.task.getName(), (Object)this.task.getUuid());
            this.cnnHandler.createConnection(this.job.isAutoCommit());
            this.cnnHandler.getConnection().setClientInfo("ApplicationName", "YODA - " + Util.removerAcentos((String)this.task.getName()));
            Bridge.setBridgeConnection((IBridgeConnectionScheduler)((IBridgeConnectionScheduler)this.cnnHandler));
            this.gravarTarefa(this.job.getBeginCallback());
            this.job.execute();
            this.commit();
            this.gravarTarefa(this.job.getEndCallback());
        }
        catch (Throwable ex) {
            this.log.error("Falha na tarefa {}", (Object)this.task.getName(), (Object)ex);
            this.rollBack();
            this.gravarFalhaTarefa(ex);
        }
        finally {
            this.releaseConnection();
            this.log.debug("Fim da tarefa {},{}", (Object)this.task.getName(), (Object)this.task.getUuid());
            this.job.setDone(true);
        }
    }

    private void gravarFalhaTarefa(Throwable ex) {
        this.task.setErrorMessage(ex.getMessage());
        this.task.setPrintStack(Util.getStackTrace((Throwable)ex));
        this.task.setErrorMessage(this.aparar(this.task.getErrorMessage(), 512));
        if (ex instanceof Exception) {
            try {
                this.job.onFailure((Exception)ex);
            }
            catch (Throwable e) {
                this.log.error("onFailure falhou para a tarefa {}", (Object)this.task.getName(), (Object)e);
            }
        }
        this.gravarTarefa(this.job.getFailureCallback());
    }

    private void gravarTarefa(Consumer<Task> conumer) {
        try {
            conumer.accept(this.task);
            this.commit();
        }
        catch (Throwable e) {
            this.rollBack();
            this.log.error("Erro ao gravar tarefa {}", (Object)this.task.getName(), (Object)e);
        }
    }

    private void releaseConnection() {
        try {
            this.cnnHandler.getConnection().setClientInfo("ApplicationName", "YODA");
            this.cnnHandler.releaseConnection();
        }
        catch (Throwable e) {
            this.log.error("Erro ao fechar a conex\u00e3o da tarefa {}", (Object)this.task.getName(), (Object)e);
        }
    }

    private void rollBack() {
        if (!this.job.isAutoCommit()) {
            this.cnnHandler.rollback();
        }
    }

    private void commit() {
        if (!this.job.isAutoCommit()) {
            this.cnnHandler.commit();
        }
    }

    private String aparar(String s, int tamanho) {
        if (s != null && s.length() > tamanho) {
            return s.substring(0, tamanho);
        }
        return s;
    }
}

