/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.pdv;

import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TaskStatus;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.yoda.app.batch.TaskServiceYoda;
import java.time.Instant;
import java.util.UUID;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import unipaf.dto.pdv.CargaBaseRequest;

@RestController
@RequestMapping(value={"/jobs-pdv/pdv-carga-base"})
public class PdvCargaBaseYodaController {
    private TaskServiceYoda taskService;

    public PdvCargaBaseYodaController(TaskServiceYoda taskService) {
        this.taskService = taskService;
    }

    @RequestMapping(value={"/gerar-arquivo"})
    @DBAutoCommit
    public synchronized String gerarArquivo(@RequestBody CargaBaseRequest request) {
        Task task = this.taskService.buscarUltimoTaskCargaBase(this.getMetaData(request));
        if (task == null || task.getTaskStatus() != TaskStatus.PROCESSING && task.getTaskStatus() != TaskStatus.ENQUEUED) {
            this.taskService.saveTask(this.criarTarefa(request));
        }
        return "";
    }

    @RequestMapping(value={"/arquivo-carga"})
    @DBAutoCommit
    public String getArquivo(@RequestBody CargaBaseRequest request) {
        Task task = this.taskService.buscarUltimoTaskCargaBase(this.getMetaData(request));
        if (task == null) {
            throw new UnicoException("YODA42", "Job da carga da base foi exclu\u00eddo.");
        }
        if (task.getTaskStatus() == TaskStatus.FAILED) {
            if (!Util.stringNullOrEmpty((String)task.getErrorMessage())) {
                throw new UnicoException("YODA44", task.getErrorMessage());
            }
            throw new UnicoException("YODA43", "A Carga da base falhou. Verifique o Log da tarefa que gerou a carga da base.");
        }
        if (task.getTaskStatus() == TaskStatus.ENQUEUED || task.getTaskStatus() == TaskStatus.PROCESSING) {
            return "";
        }
        if (task.getTaskStatus() == TaskStatus.SUCCEDED) {
            return task.getUrl();
        }
        throw new UnicoException("YODA35", "O job da carga da base ID " + task.getId() + " foi invalidado, status: " + task.getTaskStatus());
    }

    private Task criarTarefa(CargaBaseRequest request) {
        Task task = new Task();
        task.setUuid(UUID.randomUUID().toString());
        task.setT0(DataHoraFactory.ofInstant((Instant)Instant.now()));
        task.setMetadata(this.getMetaData(request));
        task.setTipoJob(TipoJob.CARGA_BASE_YODA);
        task.setName(TipoJob.CARGA_BASE_YODA.getDescricao());
        task.setClassName(TipoJob.CARGA_BASE_YODA.getClasseImplementacao());
        task.setQueue(TypeQueue.CARGA_BASE.getId());
        task.setTaskStatus(TaskStatus.ENQUEUED);
        task.setParameters(JSONUtil.getJSONObject((Object)request).toString());
        return task;
    }

    private String getMetaData(CargaBaseRequest request) {
        JobMetadata metadata = new JobMetadata();
        metadata.set("codigoFilial", request.getFilial());
        metadata.set("hash", request.getHash());
        return metadata.to();
    }
}

