/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.core.spring.config;

import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.yoda.core.spring.config.ExceptionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class RestControllerAdvice {
    private static Logger logger = LoggerFactory.getLogger(RestControllerAdvice.class);

    @ExceptionHandler(value={UnicoMensagemUsuarioException.class})
    public ResponseEntity<ExceptionResponse> unicoMensagemUsuarioException(UnicoMensagemUsuarioException ex) {
        logger.warn("UnicoMensagemUsuarioException", (Throwable)ex);
        ExceptionResponse response = new ExceptionResponse(Integer.valueOf(HttpStatus.UNPROCESSABLE_ENTITY.value()), ex.getCodigoErro(), (Throwable)ex);
        return new ResponseEntity((Object)response, HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @ExceptionHandler(value={UnicoException.class})
    public ResponseEntity<ExceptionResponse> unicoException(UnicoException ex) {
        logger.error("Erro na api causada pela exception", (Throwable)ex);
        ExceptionResponse response = new ExceptionResponse(Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()), ex.getCodigoErro(), (Throwable)ex);
        return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ExceptionResponse> exception(Exception ex) {
        logger.error("Erro na api causada pela exception", (Throwable)ex);
        ExceptionResponse response = new ExceptionResponse(Integer.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()), "Erro interno no servidor", (Throwable)ex);
        return new ResponseEntity((Object)response, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ExceptionResponse> methodArgumentNotValidException(MethodArgumentNotValidException ex) {
        logger.error("Erro na valida\u00e7\u00e3o dos dados", (Throwable)ex);
        ExceptionResponse response = new ExceptionResponse(Integer.valueOf(HttpStatus.BAD_REQUEST.value()), "Erro na valida\u00e7\u00e3o dos dados", (Throwable)ex);
        return new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }
}

