/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.retaguarda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.util.ArrayList;
import java.util.List;
import unichef.catraca.CatracaFactory;
import unichef.catraca.ICatraca;

public class CatracaScheduler
extends RecurringYodaJob {
    private static List<ICatraca> catracasPorFilial;
    private UnicoMensagemUsuarioException ultimaEx;

    public CatracaScheduler() {
        super(Cron.every5seconds(), TipoJob.CATRACA_YODA);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        this.ultimaEx = null;
        Sessao sessao = Contexto.getInstance().getSessao();
        List catracas = this.getCatracasPorFilial();
        for (ICatraca catraca : catracas) {
            try {
                catraca.atualizarComandas(sessao);
            }
            catch (UnicoMensagemUsuarioException ex) {
                this.taskError("Erro ao atualizar a catraca para a filial c\u00f3digo " + catraca.getFilial().getCodigo() + ".", ex);
            }
        }
        if (this.ultimaEx != null) {
            throw this.ultimaEx;
        }
    }

    public boolean isAtivo() {
        return FilialRN.getInstance().buscarLista().stream().anyMatch(f -> f.getParametrosCatraca().isCatracaHabilitada());
    }

    private List<ICatraca> getCatracasPorFilial() {
        if (catracasPorFilial == null) {
            catracasPorFilial = new ArrayList();
            for (Filial filial : FilialRN.getInstance().buscarLista()) {
                if (!filial.getParametrosCatraca().isCatracaHabilitada()) continue;
                try {
                    ICatraca catraca = CatracaFactory.construir((Filial)filial);
                    catracasPorFilial.add(catraca);
                }
                catch (UnicoMensagemUsuarioException ex) {
                    this.taskError("Erro ao iniciar a catraca para a filial c\u00f3digo " + filial.getCodigo() + ".", ex);
                }
            }
        }
        return catracasPorFilial;
    }

    private void taskError(String mensagem, UnicoMensagemUsuarioException ex) {
        this.ultimaEx = ex;
        this.log.error(mensagem, (Throwable)ex);
    }
}

