/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.gnre;

import br.intelidata.commons.core.documentosfiscais.gnre.TransmissorGnre;
import br.intelidata.commons.core.documentosfiscais.gnre.TransmissorGnreLocal;
import br.intelidata.commons.core.documentosfiscais.gnre.pojo.ConsultaConfigUf;
import br.intelidata.commons.core.documentosfiscais.gnre.pojo.ResultadoLote;
import br.intelidata.commons.core.documentosfiscais.gnre.pojo.RetornoLote;
import br.intelidata.commons.core.documentosfiscais.gnre.pojo.remoto.ConsultaConfigUfRequest;
import br.intelidata.commons.core.documentosfiscais.gnre.pojo.remoto.ConsultarReciboRequest;
import br.intelidata.commons.core.documentosfiscais.gnre.pojo.remoto.LoteRequest;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/gnre/"})
public class GnreController {
    @RequestMapping(value={"consultarConfigUf"})
    @DBAutoCommit
    public ConsultaConfigUf consultarConfigUf(@RequestBody ConsultaConfigUfRequest request) throws Exception {
        TransmissorGnre transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.consultarConfigUf(request.getEstado(), request.getReceita());
    }

    @RequestMapping(value={"enviarLote"})
    @DBAutoCommit
    public RetornoLote enviarLote(@RequestBody LoteRequest request) throws Exception {
        TransmissorGnre transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.enviarLote(request.getGuias());
    }

    @RequestMapping(value={"consultarRecibo"})
    @DBAutoCommit
    public ResultadoLote consultarRecibo(@RequestBody ConsultarReciboRequest request) throws Exception {
        TransmissorGnre transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.consultarRecibo(request.getRecibo());
    }

    private TransmissorGnre getTransmissor(Long idFilial) throws UnicoMensagemUsuarioException {
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(idFilial);
        return new TransmissorGnreLocal(filial);
    }
}

