/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.nfsenacional;

import br.intelidata.commons.core.documentosfiscais.common.pojo.remoto.ConsultaDataCertificado;
import br.intelidata.commons.core.documentosfiscais.common.pojo.remoto.PojoRemoto;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfsenacional.TransmissorNFSe;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfsenacional.TransmissorNFSeLocal;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfsenacional.pojo.remoto.AutorizarDPSRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfsenacional.pojo.remoto.ConsultarRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfsenacional.pojo.remoto.TransmitirEventoRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfsenacional.response.ConsultaDPSResponse;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfsenacional.response.ConsultaEventoResponse;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfsenacional.response.ConsultaLoteEventoResponse;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfsenacional.response.DPSResponse;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfsenacional.response.EventoResponse;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nfsenacional/"})
public class NFSeNacionalController {
    @RequestMapping(value={"autorizar"})
    @DBAutoCommit
    public DPSResponse autorizar(@RequestBody AutorizarDPSRequest request) throws Exception {
        return this.getTransmissor((PojoRemoto)request).autorizar(request.getDps(), request.isValidarSchema());
    }

    @RequestMapping(value={"transmitirEvento"})
    @DBAutoCommit
    public EventoResponse transmitirEvento(@RequestBody TransmitirEventoRequest request) throws Exception {
        return this.getTransmissor((PojoRemoto)request).transmitirEvento(request.getEvento(), request.getChaveAcesso());
    }

    @RequestMapping(value={"consultarEventos"})
    @DBAutoCommit
    public ConsultaLoteEventoResponse consultarEventos(@RequestBody ConsultarRequest request) throws Exception {
        return this.getTransmissor((PojoRemoto)request).consultarEventos(request.getChave());
    }

    @RequestMapping(value={"buscarDanfe"})
    @DBAutoCommit
    public byte[] buscarDanfe(@RequestBody ConsultarRequest request) throws Exception {
        return this.getTransmissor((PojoRemoto)request).buscarDanfe(request.getChave());
    }

    @RequestMapping(value={"consultarPorChaveNFSe"})
    @DBAutoCommit
    public DPSResponse consultarPorChaveNFSe(@RequestBody ConsultarRequest request) throws Exception {
        return this.getTransmissor((PojoRemoto)request).consultarPorChaveNFSe(request.getChave());
    }

    @RequestMapping(value={"consultarPorChaveDPS"})
    @DBAutoCommit
    public ConsultaDPSResponse consultarPorChaveDPS(@RequestBody ConsultarRequest request) throws Exception {
        return this.getTransmissor((PojoRemoto)request).consultarPorChaveDPS(request.getChave());
    }

    @RequestMapping(value={"consultarEvento"})
    @DBAutoCommit
    public ConsultaEventoResponse consultarEvento(@RequestBody ConsultarRequest request) throws Exception {
        return this.getTransmissor((PojoRemoto)request).consultarEvento(request.getChave(), request.getTipo(), request.getSequencia());
    }

    private TransmissorNFSe getTransmissor(PojoRemoto request) throws UnicoMensagemUsuarioException {
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(Long.valueOf(request.getIdFilial()));
        return new TransmissorNFSeLocal(filial);
    }

    @RequestMapping(value={"dataCertificado"})
    @DBAutoCommit
    public ConsultaDataCertificado dataCertificado(@RequestBody PojoRemoto request) throws Exception {
        return new ConsultaDataCertificado(this.getTransmissor(request).getDataCertificado());
    }
}

