/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.notafiscal;

import br.intelidata.commons.core.documentosfiscais.common.pojo.remoto.ConsultaDataCertificado;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.TransmissorNfe;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.nfe4.TransmissorNfe4Local;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.EnvioEventoNFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.NfeXML;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.RetornoConsultaCadastroNFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.RetornoConsultaDFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.RetornoConsultaReciboNFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.RetornoConsultaSituacaoNFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.RetornoConsultaStatusServicoNFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.RetornoEnvioEventoNFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.RetornoEnvioNFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.RetornoInutilizacaoNFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.AssinarEventoNfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.AssinarNfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.AutorizarNfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.ConsultaCadastroRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.ConsultaDfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.ConsultaNfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.ConsultaStatusNfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.ConsultaStatusReciboNfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.DownloadNfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.InutilizarNfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.PojoNfeRemoto;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfe.pojo.remoto.RecepcaoEventoNfeRequest;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.FormaEmissaoNfe;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/nfe4/"})
public class Nfe4Controller {
    @RequestMapping(value={"statusServico"})
    @DBAutoCommit
    public RetornoConsultaStatusServicoNFE getStatusServico(@RequestBody ConsultaStatusNfeRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfe transmissor = this.getTransmissor((PojoNfeRemoto)request);
        return transmissor.getStatusServico(request.isValidarSchema());
    }

    @RequestMapping(value={"autorizar"})
    @DBAutoCommit
    public RetornoEnvioNFE autorizar(@RequestBody AutorizarNfeRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfe transmissor = this.getTransmissor((PojoNfeRemoto)request);
        return transmissor.autorizar(request.getSessao(), request.getNroLote(), request.getMapNfe(), request.isValidarSchema());
    }

    @RequestMapping(value={"consultarRecibo"})
    @DBAutoCommit
    public RetornoConsultaReciboNFE consultarRecibo(@RequestBody ConsultaStatusReciboNfeRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfe transmissor = this.getTransmissor((PojoNfeRemoto)request);
        return transmissor.consultarRecibo(request.getNumeroRecibo(), request.isValidarSchema());
    }

    @RequestMapping(value={"inutilizar"})
    @DBAutoCommit
    public RetornoInutilizacaoNFE inutilizaNfe(@RequestBody InutilizarNfeRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfe transmissor = this.getTransmissor((PojoNfeRemoto)request);
        return transmissor.inutilizaNfe(request.getcUF(), request.getAno(), request.getCnpj(), request.getModelo(), request.getSerie(), request.getnNFIni(), request.getnNFFin(), request.getJustificativa(), request.isValidarSchema());
    }

    @RequestMapping(value={"consultar"})
    @DBAutoCommit
    public RetornoConsultaSituacaoNFE consultar(@RequestBody ConsultaNfeRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfe transmissor = this.getTransmissor((PojoNfeRemoto)request);
        return transmissor.consultar(request.getChaveAcesso(), request.isValidarSchema());
    }

    @RequestMapping(value={"recepcaoEvento"})
    @DBAutoCommit
    public RetornoEnvioEventoNFE recepcaoEvento(@RequestBody RecepcaoEventoNfeRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfe transmissor = this.getTransmissor((PojoNfeRemoto)request);
        return transmissor.recepcaoEvento(request.getEnvioEvento(), request.isValidarSchema());
    }

    @RequestMapping(value={"consultarDfe"})
    @DBAutoCommit
    public RetornoConsultaDFE consultarDfe(@RequestBody ConsultaDfeRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfe transmissor = this.getTransmissor((PojoNfeRemoto)request);
        return transmissor.consultarDfe(request.getEstado(), request.getCnpj(), request.getUltimoNSU().longValue(), request.isValidarSchema());
    }

    @RequestMapping(value={"downloadNF"})
    @DBAutoCommit
    public RetornoConsultaDFE downloadNF(@RequestBody DownloadNfeRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfe transmissor = this.getTransmissor((PojoNfeRemoto)request);
        return transmissor.downloadNF(request.getChave(), request.getCnpj(), request.isValidarSchema());
    }

    @RequestMapping(value={"consultaCadastro"})
    @DBAutoCommit
    public RetornoConsultaCadastroNFE consultaCadastro(@RequestBody ConsultaCadastroRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfe transmissor = this.getTransmissor((PojoNfeRemoto)request);
        return transmissor.consultaCadastro(request.getDocumento(), request.getEstado(), request.isValidarSchema());
    }

    @RequestMapping(value={"assinarNfe"})
    @DBAutoCommit
    public NfeXML assinarNfe(@RequestBody AssinarNfeRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfe transmissor = this.getTransmissor((PojoNfeRemoto)request);
        return transmissor.assinarNfe(request.getNfeXML());
    }

    @RequestMapping(value={"assinarEvento"})
    @DBAutoCommit
    public EnvioEventoNFE assinarEvento(@RequestBody AssinarEventoNfeRequest request) throws UnicoMensagemUsuarioException {
        TransmissorNfe transmissor = this.getTransmissor((PojoNfeRemoto)request);
        return transmissor.assinarEvento(request.getEnvioEventoNFE());
    }

    @RequestMapping(value={"dataCertificado"})
    @DBAutoCommit
    public ConsultaDataCertificado dataCertificado(@RequestBody PojoNfeRemoto request) throws Exception {
        TransmissorNfe transmissor = this.getTransmissor(request);
        return new ConsultaDataCertificado(transmissor.getDataCertificado());
    }

    private TransmissorNfe getTransmissor(PojoNfeRemoto request) throws UnicoMensagemUsuarioException {
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(Long.valueOf(request.getIdFilial()));
        TransmissorNfe4Local transmissorNfe = new TransmissorNfe4Local(filial, request.isNfce());
        if (!FormaEmissaoNfe.NORMAL.equals((Object)request.getFormaEmissao())) {
            transmissorNfe.configurarTransmissorPorFormaEmissao(request.getFormaEmissao());
        }
        return transmissorNfe;
    }
}

