/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.core.spring.config.oauth2;

import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.yoda.core.spring.config.oauth2.CustomJwtTokenStoreYoda;
import br.intelidata.yoda.core.spring.config.oauth2.YodaClientDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.DefaultTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.stereotype.Component;

@Component
@EnableAuthorizationServer
public class OAuth2AuthorizationServer
extends AuthorizationServerConfigurerAdapter {
    @Autowired
    private IConnectionHandler connectionHandler;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @Primary
    public DefaultTokenServices tokenServices() {
        DefaultTokenServices tokenServices = new DefaultTokenServices();
        tokenServices.setTokenStore((TokenStore)this.jwtTokenStore());
        tokenServices.setSupportRefreshToken(true);
        return tokenServices;
    }

    @Bean
    public JwtTokenStore jwtTokenStore() {
        return new CustomJwtTokenStoreYoda(this.accessTokenConverter(), this.connectionHandler);
    }

    @Bean
    public JwtAccessTokenConverter accessTokenConverter() {
        JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
        converter.setSigningKey("zx09qwe98df76kj12u72bdjd7203543mjzbndh");
        converter.setVerifier(this.verifier());
        return converter;
    }

    @Bean
    public SignatureVerifier verifier() {
        return new MacSigner("zx09qwe98df76kj12u72bdjd7203543mjzbndh");
    }

    public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
        endpoints.tokenStore((TokenStore)this.jwtTokenStore()).accessTokenConverter((AccessTokenConverter)this.accessTokenConverter());
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        clients.withClientDetails((ClientDetailsService)new YodaClientDetailsService(this.passwordEncoder()));
    }
}

