SELECT
  produtoeservico.codigointerno        codigo,
  produto.codigobarra,
  produtoeservico.descricao,
  produtoeservico.ativo,
  produtoeservico.observacao,
  produtoeservico.iat,
  produtoeservico.ippt,
  produtoeservico.cest,
  produtoeservicoempresa.precovenda,
  produtoeservicoempresa.precocusto,
  produtoeservicoempresa.precocustomedio,
  produtoeservicoempresa.numerofci,
  produtoempresa.quantidade,
  produtoempresa.quantidademinima,
  produtoempresa.quantidademaxima,
  produtoeservico.percentualcomissao   comissao,
  unidademedida.sigla                  unidade,
  produto.pesoliquido,
  produto.pesobruto,
  produto.pesavel,
  codigofiscaltributario.numero        ncm,
  tributacaoestadual.descricao         descricaoicms,
  cstipisaida.codigo                   cstipisaida,
  cstipientrada.codigo                 cstipientrada,
  tributacaoipisaida.valorunidadeipi   valorunidadeipisaida,
  tributacaoipisaida.percentualipi     percentualipisaida,
  tributacaoipientrada.valorunidadeipi valorunidadeipientrada,
  tributacaoipientrada.percentualipi   percentualipientrada,
  codigoenquadramentoipi.codigo        enquadramentoipi,
  cstpisentrada.codigo                 cstpisentrada,
  tributacaopisentrada.percentual      pisentrada,
  cstpissaida.codigo                   cstpissaida,
  tributacaopissaida.percentual        pissaida,
  cstcofinsentrada.codigo              cstcofinsentrada,
  tributacaocofinsentrada.percentual   cofinsentrada,
  cstcofinssaida.codigo                cstcofinssaida,
  tributacaocofinssaida.percentual     cofinssaida
FROM
  produtoeservico
  LEFT JOIN produtoeservicoempresa ON produtoeservico.id = produtoeservicoempresa.produtoeservicoid
  LEFT JOIN unidademedida ON produtoeservico.unidademedidaid = unidademedida.id
  LEFT JOIN produto ON produtoeservico.produtoid = produto.id
  LEFT JOIN produtoempresa ON produtoeservicoempresa.produtoempresaid = produtoempresa.id
  LEFT JOIN tributacaofederal ON produtoeservico.tributacaofederalid = tributacaofederal.id
  LEFT JOIN tributacaoestadual ON produtoempresa.produtotributacaoestadualid = tributacaoestadual.id
  LEFT JOIN tributacaoipi ON tributacaofederal.tributacaoipiid = tributacaoipi.id
  LEFT JOIN tributacaoipientrada ON tributacaoipi.tributacaoipientradaid = tributacaoipientrada.id
  LEFT JOIN tributacaoipisaida ON tributacaoipi.tributacaoipisaidaid = tributacaoipisaida.id
  LEFT JOIN codigoenquadramentoipi ON tributacaoipi.codigoenquadramentoipiid = codigoenquadramentoipi.id
  LEFT JOIN cstipi cstipientrada ON tributacaoipientrada.cstipiid = cstipientrada.id
  LEFT JOIN cstipi cstipisaida ON tributacaoipisaida.cstipiid = cstipisaida.id
  LEFT JOIN tributacaopiscofins ON tributacaofederal.tributacaopiscofinsid = tributacaopiscofins.id
  LEFT JOIN tributacaopisentrada ON tributacaopisentrada.id = tributacaopiscofins.tributacaopisentradaid
  LEFT JOIN cstpiscofins cstpisentrada ON cstpisentrada.id = tributacaopisentrada.cstpiscofinsid
  LEFT JOIN tributacaopissaida ON tributacaopissaida.id = tributacaopiscofins.tributacaopissaidaid
  LEFT JOIN cstpiscofins cstpissaida ON cstpissaida.id = tributacaopissaida.cstpiscofinsid
  LEFT JOIN tributacaocofinsentrada ON tributacaocofinsentrada.id = tributacaopiscofins.tributacaocofinsentradaid
  LEFT JOIN cstpiscofins cstcofinsentrada ON cstcofinsentrada.id = tributacaocofinsentrada.cstpiscofinsid
  LEFT JOIN tributacaocofinssaida ON tributacaocofinssaida.id = tributacaopiscofins.tributacaocofinssaidaid
  LEFT JOIN cstpiscofins cstcofinssaida ON cstcofinssaida.id = tributacaocofinssaida.cstpiscofinsid
  LEFT JOIN codigofiscaltributario ON codigofiscaltributario.id = produtoeservico.ncmid
