/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.atualizador;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.sql.SGBDManager;
import br.intelidata.commons.core.sql.SqlNativo;
import br.intelidata.commons.core.util.Util;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.yoda.app.yoda.util.SwingUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@SuppressFBWarnings(value={"DM_EXIT"}, justification="Fecha caso n\u00e3o possa atualizar a database.")
public class AtualizacaoBaseYoda {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtualizacaoBaseYoda.class);
    private String buildSistema;
    private final IConnectionHandler connectionHandler;

    @Autowired
    public AtualizacaoBaseYoda(IConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public void verificarAtualizacaoBase() {
        this.connectionHandler.createConnection(true);
        if (this.isAtualizarBase()) {
            LOGGER.info("Verificando atualiza\u00e7\u00f5es na base de dados ...");
            try {
                this.atualizacaoBaseDados();
            }
            catch (Throwable ex) {
                LOGGER.error(ex.getMessage(), ex);
                String mensagemErro = "N\u00e3o foi poss\u00edvel atualizar a base de dados.\nTente novamente mais tarde, ou utilize o atualizador de base de dados.\nSe o problema persistir entre em contato com o suporte.";
                if (ex instanceof UnicoMensagemUsuarioException) {
                    mensagemErro = mensagemErro + "\n" + ((UnicoMensagemUsuarioException)ex).getMensagemSemCodigo();
                }
                SwingUtil.showMensagemInformacaoComTempo((String)"", (String)mensagemErro, (int)5, (boolean)false);
                this.connectionHandler.releaseConnection();
                System.exit(1);
            }
            LOGGER.info("Verifica\u00e7\u00e3o conclu\u00edda");
        }
        this.connectionHandler.releaseConnection();
    }

    private void atualizacaoBaseDados() throws UnicoMensagemUsuarioException {
        SGBDManager.getInstance().atualizarBaseNovo(null, false);
    }

    private boolean isAtualizarBase() {
        try {
            this.carregarDadosAtualizacaoBase();
            return Util.converteVersao((String)this.buildSistema) < Util.converteVersao((String)UnicoSistema.getVersao());
        }
        catch (UnicoMensagemUsuarioException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private void carregarDadosAtualizacaoBase() throws UnicoMensagemUsuarioException {
        SGBDManager.getInstance().atualizaTabelaControle();
        this.buildSistema = "";
        if (SGBDManager.getInstance().existeTabela("controle")) {
            SqlNativo sql = new SqlNativo("SELECT chavesestrangeiras, buildatual, buildsistema FROM controle");
            sql.executaQuery();
            if (sql.next()) {
                this.buildSistema = sql.getString("buildsistema");
            }
            sql.close();
        }
    }
}

