/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch;

import br.intelidata.commons.core.client.batch.BatchDashBoardResponse;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.cron.CronExpression;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.batch.TaskStatus;
import br.intelidata.yoda.app.batch.TaskManagerYoda;
import br.intelidata.yoda.app.batch.TaskProcessorYoda;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;

public class BatchDashBoard {
    private BatchDashBoardResponse response = new BatchDashBoardResponse();
    private OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private MemoryMXBean mmxb = ManagementFactory.getMemoryMXBean();
    private TaskProcessorYoda taskProcessor;

    public BatchDashBoard(TaskProcessorYoda taskProcessor) {
        this.taskProcessor = taskProcessor;
    }

    public BatchDashBoardResponse gerar() {
        this.cpu();
        this.memoria();
        this.disco();
        this.tarefas();
        return this.response;
    }

    private void cpu() {
        this.response.setOs(this.osmxb.getName() + " " + this.osmxb.getVersion() + " (" + this.osmxb.getArch() + ")");
        this.response.setProcessadores(this.osmxb.getAvailableProcessors());
        this.response.setCpu(this.taskProcessor.cpuUsage());
        this.response.setThreads(this.taskProcessor.getThreads());
        this.response.setThreadsDisponiveis(this.taskProcessor.getThreadsDisponiveis());
        this.response.setTempoExecucao(this.taskProcessor.getTempoExecucao());
    }

    private void memoria() {
        this.response.setMemoriaTotal(this.osmxb.getTotalPhysicalMemorySize());
        this.response.setMemoriaLivre(this.osmxb.getFreePhysicalMemorySize());
        this.response.setMaxHeap(this.mmxb.getHeapMemoryUsage().getMax());
        this.response.setUsedHeap(this.mmxb.getHeapMemoryUsage().getUsed());
        this.response.setUsedNonHeap(this.mmxb.getNonHeapMemoryUsage().getUsed());
    }

    private void disco() {
        File f = new File(".");
        this.response.setTamanhoDisco(f.getTotalSpace());
        this.response.setEspacoLivreDisco(f.getFreeSpace());
    }

    private void tarefas() {
        TaskManagerYoda taskManagerYoda = this.taskProcessor.getTaskManagerYoda();
        this.response.setTarefasFila(taskManagerYoda.getTasks(new TaskStatus[]{TaskStatus.ENQUEUED}).size());
        this.response.setTarefasPausadas(taskManagerYoda.getTasks(new TaskStatus[]{TaskStatus.PAUSED}).size());
        this.response.setTarefasComFalha(taskManagerYoda.getTasks(new TaskStatus[]{TaskStatus.FAILED}).size());
        this.response.setProximaExecucao(this.getProximoAgendamento(taskManagerYoda));
    }

    private LocalDateTime getProximoAgendamento(TaskManagerYoda taskManagerYoda) {
        LocalDateTime menorExecucao = null;
        List tasks = taskManagerYoda.getTasks(new TaskStatus[]{TaskStatus.SCHEDULED});
        for (Task task : tasks) {
            CronExpression cronExpression = CronExpression.create((String)task.getCronExpression());
            LocalDateTime proxima = DataHoraFactory.ofInstantUTC((Instant)cronExpression.next(task.getT0().toInstant(ZoneOffset.UTC), (ZoneId)ZoneOffset.UTC));
            if (menorExecucao != null && !proxima.isBefore(menorExecucao)) continue;
            menorExecucao = proxima;
        }
        return menorExecucao;
    }
}

