/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch;

import br.intelidata.api.batch.RecurringJob;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.yoda.app.batch.YodaJob;
import br.intelidata.yoda.app.batch.YodaJobExecutor;
import br.intelidata.yoda.app.yoda.configuration.ApplicationContextProvider;
import br.intelidata.yoda.core.spring.sgbd.ConnectionHandler;

public abstract class RecurringYodaJob
extends RecurringJob
implements YodaJob {
    private boolean autoCommit = true;

    protected RecurringYodaJob(String cronExpression, TipoJob tipoJob) {
        super(tipoJob.getDescricao(), cronExpression, TypeQueue.RECURRING_QUEUE.getId(), tipoJob);
    }

    public void run() {
        new YodaJobExecutor((YodaJob)this).executar();
    }

    public void prepareTenant() {
    }

    public void prepareSession() {
    }

    public void onFailure(Exception ex) {
    }

    public boolean isAtivo() {
        return true;
    }

    public IConnectionHandler getConnectionHandler() {
        if (this.connectionHandler == null) {
            this.connectionHandler = (IConnectionHandler)ApplicationContextProvider.getBean(ConnectionHandler.class);
        }
        return this.connectionHandler;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    protected String toDailyCron(String preferencia) {
        if (Util.stringNullOrEmpty((String)preferencia)) {
            return "";
        }
        String[] split = preferencia.split(":");
        if (split.length != 2) {
            return "";
        }
        int hora = Util.string2int((String)split[0]);
        int minuto = Util.string2int((String)split[1]);
        if (hora < 0 || hora > 24 || minuto < 0 || minuto > 60) {
            return "";
        }
        return Cron.daily((int)hora, (int)minuto);
    }

    protected boolean isExecutarNoServidorSecundario() {
        return true;
    }
}

