/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.retaguarda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.Agendamento;
import br.intelidata.commons.domain.pojo.CalculoCustoMedioAgendamento;
import br.intelidata.commons.domain.pojo.enuns.TarefaAgendamento;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.CalculoCustoMedioAgendamentoCommonRN;
import br.intelidata.commons.domain.regranegocio.CustoMedioDiarioCommonRN;
import br.intelidata.commons.modulo.ferramentas.agendamento.regranegocio.AgendamentoRN;
import br.intelidata.commons.modulo.produto.regranegocio.CustoProdutoRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.util.List;

public class CustoMedioScheduler
extends RecurringYodaJob {
    private Sessao sessao = Contexto.getInstance().getSessao();
    private CalculoCustoMedioAgendamento agendamento = (CalculoCustoMedioAgendamento)CalculoCustoMedioAgendamentoCommonRN.getInstance().buscaAgendamento(TarefaAgendamento.CALCULO_DE_CUSTO_MEDIO.getId());

    public CustoMedioScheduler() {
        super(Cron.daily((int)3), TipoJob.CUSTO_MEDIO_YODA);
        this.setCronConfiguradoTelaEspecifica(true);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        boolean gestaoCustoPreco = FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.GESTAO_CUSTO_PRECO);
        if (gestaoCustoPreco) {
            CustoProdutoRN.getInstance().calcularCustoMedio(this.sessao);
        } else {
            List registrosPendentes = CustoMedioDiarioCommonRN.getInstance().buscarRegistrosPendentesEmpresaOrdenadaAnoMes(this.sessao.getFilial().getIdEmpresa());
            boolean temRegistroSemFilial = registrosPendentes.stream().anyMatch(cmd -> cmd.getIdFilial() == null);
            if (temRegistroSemFilial) {
                throw new UnicoMensagemUsuarioException("YODA29", "Existem registros de custo m\u00e9dio sem filial relacionada.");
            }
            CustoMedioDiarioCommonRN.getInstance().iniciarCalculoJob(registrosPendentes, this.sessao);
        }
        this.getTask().setRetorno("Finalizado o c\u00e1lculo de custo m\u00e9dio." + (gestaoCustoPreco ? " (Gest\u00e3o de custo e pre\u00e7o)" : ""));
    }

    public boolean isAtivo() {
        return this.agendamento != null && !Util.stringNullOrEmpty((String)this.agendamento.getHoras());
    }

    public String getCronExpression() {
        return AgendamentoRN.getInstance().getExpressaoCron((Agendamento)this.agendamento, "0");
    }
}

