/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.retaguarda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.BancoOnlineRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegracaoBancoOnlineScheduler
extends RecurringYodaJob {
    public IntegracaoBancoOnlineScheduler() {
        super(Cron.daily(), TipoJob.INTEGRACAO_BANCO_ONLINE);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        Logger log = LoggerFactory.getLogger(IntegracaoBancoOnlineScheduler.class);
        new BancoOnlineRN().sincronizar(Contexto.getInstance().getSessao(), log);
    }

    public boolean abstractControlTransaction() {
        return false;
    }

    public boolean isAtivo() {
        return FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.BANCO_ONLINE);
    }

    protected boolean isExecutarNoServidorSecundario() {
        return false;
    }
}

