/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.mdfe;

import br.intelidata.commons.core.documentosfiscais.common.pojo.remoto.ConsultaDataCertificado;
import br.intelidata.commons.core.documentosfiscais.common.pojo.remoto.PojoRemoto;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.TransmissorMdfe;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.TransmissorMdfeLocal;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.EnvioMDFe;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.RetornoConsultaMDFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.RetornoConsultaMDFENaoEncerrado;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.RetornoConsultaStatusServicoMDFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.RetornoDistribuicaoMDFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.RetornoEnvioMDFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.RetornoEventoMDFE;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.AssinarChaveMdfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.AssinarMdfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.CancelarMdfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.ConsultaDfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.ConsultaMdfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.ConsultaNaoEncerradosRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.ConsultaStatusMdfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.EncerrarMdfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.IncluirCondutorMdfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.PagamentoFreteMdfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.ProcessarMdfeRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.mdfe.pojo.remoto.RetornoAssinaturaChaveMDFE;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdfe/"})
public class MdfeController {
    @RequestMapping(value={"statusServico"})
    @DBAutoCommit
    public RetornoConsultaStatusServicoMDFE statusServico(@RequestBody ConsultaStatusMdfeRequest request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.getStatusServico();
    }

    @RequestMapping(value={"processar"})
    @DBAutoCommit
    public RetornoEnvioMDFE enviarLote(@RequestBody ProcessarMdfeRequest request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.processaMdfe(request.getManifestoDocumentoXML());
    }

    @RequestMapping(value={"encerrar"})
    @DBAutoCommit
    public RetornoEventoMDFE encerrar(@RequestBody EncerrarMdfeRequest request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.encerrarMDFe(request.getcOrgao(), request.getCnpj(), request.getChMDFe(), request.getDataEvento(), request.getProtocolo(), request.getDataEncerramento(), request.getCodigoUfEncerramento(), request.getCodigoMunicipioEncerramento());
    }

    @RequestMapping(value={"pagamentoFrete"})
    @DBAutoCommit
    public RetornoEventoMDFE pagamentoFrete(@RequestBody PagamentoFreteMdfeRequest request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.enviarEventoPagamentoFrete(request.getcOrgao(), request.getCnpj(), request.getChMDFe(), request.getDataEvento(), request.getSequencia(), request.getEventoPagamentoTransporteMDFE());
    }

    @RequestMapping(value={"cancelar"})
    @DBAutoCommit
    public RetornoEventoMDFE cancelar(@RequestBody CancelarMdfeRequest request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.cancelarMDFe(request.getcOrgao(), request.getCnpj(), request.getChMDFe(), request.getDataEvento(), request.getProtocolo(), request.getJustificativa());
    }

    @RequestMapping(value={"incluirCondutor"})
    @DBAutoCommit
    public RetornoEventoMDFE incluirCondutor(@RequestBody IncluirCondutorMdfeRequest request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.inclusaoCondutor(request.getcOrgao(), request.getCnpj(), request.getChMDFe(), request.getDataEvento(), request.getSequencia(), request.getNomeCondutor(), request.getCpfCondutor());
    }

    @RequestMapping(value={"consultar"})
    @DBAutoCommit
    public RetornoConsultaMDFE consultar(@RequestBody ConsultaMdfeRequest request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.consultarMDFe(request.getChaveAcesso());
    }

    @RequestMapping(value={"consultarDfe"})
    @DBAutoCommit
    public RetornoDistribuicaoMDFE consultarDfe(@RequestBody ConsultaDfeRequest request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.consultarDFe(request.getCpfCnpj(), request.getUltimoNSU());
    }

    @RequestMapping(value={"consultarNaoEncerrados"})
    @DBAutoCommit
    public RetornoConsultaMDFENaoEncerrado consultarNaoEncerrados(@RequestBody ConsultaNaoEncerradosRequest request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.consultarNaoEncerrados(request.getCpfCnpj());
    }

    @RequestMapping(value={"assinar"})
    @DBAutoCommit
    public EnvioMDFe assinar(@RequestBody AssinarMdfeRequest request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.assinar(request.getEnvioMDFe());
    }

    @RequestMapping(value={"dataCertificado"})
    @DBAutoCommit
    public ConsultaDataCertificado dataCertificado(@RequestBody PojoRemoto request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return new ConsultaDataCertificado(transmissor.getDataCertificado());
    }

    @RequestMapping(value={"assinarChaveMDFE"})
    @DBAutoCommit
    public RetornoAssinaturaChaveMDFE assinarChaveMDFE(@RequestBody AssinarChaveMdfeRequest request) throws Exception {
        TransmissorMdfe transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return new RetornoAssinaturaChaveMDFE(transmissor.assinarChaveMdfe(request.getChaveMDFe()));
    }

    private TransmissorMdfe getTransmissor(Long idFilial) throws UnicoMensagemUsuarioException {
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(idFilial);
        return new TransmissorMdfeLocal(filial);
    }
}

