SELECT *
FROM (
       SELECT
         p.procod,
         p.prodes,
         p.prodesrdz,
         p.prounid,
         p.trbid,
         p.proprccst,
         p.proprc1,
         p.proprccstmed,
         p.proncm,
         p.proipi,
         COALESCE(imp_cof.impfedst, '98')   cst_pis_cofins_entrada,
         COALESCE(imp_cof.impfedstsai, '49')  cst_pis_cofins_saida,
         COALESCE(imp_cof.impfedalq, 0)    percentual_cofins_entrada,
         COALESCE(imp_cof.impfedalqsai, 0) percentual_cofins_saida,
         COALESCE(imp_pis.impfedalq, 0)    percentual_pis_entrada,
         COALESCE(imp_pis.impfedalqsai, 0) percentual_pis_saida
       FROM produto p
         LEFT JOIN impostos_federais_produto imp_prod_cof ON p.procod = imp_prod_cof.procod
         LEFT JOIN impostos_federais imp_cof ON imp_cof.impfedsim = imp_prod_cof.impfedsim AND imp_cof.impfedtip = 'C'
         LEFT JOIN impostos_federais_produto imp_prod_pis ON p.procod = imp_prod_pis.procod
         LEFT JOIN impostos_federais imp_pis ON imp_pis.impfedsim = imp_prod_pis.impfedsim AND imp_pis.impfedtip = 'P'
     ) AS produto
ORDER BY cast(procod AS BIGINT)