/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch;

import br.intelidata.api.batch.AbstractTaskManager;
import br.intelidata.api.batch.BatchService;
import br.intelidata.api.batch.ITask;
import br.intelidata.api.batch.RecurringJob;
import br.intelidata.commons.core.execoes.BatchException;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.batch.TaskStatus;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.yoda.app.batch.BatchServiceYoda;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import br.intelidata.yoda.app.batch.TaskServiceYoda;
import br.intelidata.yoda.app.batch.pdv.ConsultaStatusServicoScheduler;
import br.intelidata.yoda.app.batch.pdv.ContaIntegracaoScheduler;
import br.intelidata.yoda.app.batch.pdv.ContadorAlertasScheduler;
import br.intelidata.yoda.app.batch.pdv.CresceVendasScheduler;
import br.intelidata.yoda.app.batch.pdv.EnvioPendenciaNfceEmailScheduler;
import br.intelidata.yoda.app.batch.pdv.MonitorDotzScheduler;
import br.intelidata.yoda.app.batch.pdv.MonitorMercafacilScheduler;
import br.intelidata.yoda.app.batch.pdv.MonitorNfceScheduler;
import br.intelidata.yoda.app.batch.pdv.ProcessadorTransacoesScheduler;
import br.intelidata.yoda.app.batch.pdv.ScanntechCanaisVendaScheduler;
import br.intelidata.yoda.app.batch.pdv.ScanntechConsultaSolicitacoesReenvioScheduler;
import br.intelidata.yoda.app.batch.pdv.ScanntechEnvioOperacoesScheduler;
import br.intelidata.yoda.app.batch.pdv.ScanntechScheduler;
import br.intelidata.yoda.app.batch.pdv.ValidaReducaoZScheduler;
import br.intelidata.yoda.app.batch.retaguarda.CatracaScheduler;
import br.intelidata.yoda.app.batch.retaguarda.ConciliacaoRecebimentoScheduler;
import br.intelidata.yoda.app.batch.retaguarda.CotacaoOnlineTomadaPrecoScheduler;
import br.intelidata.yoda.app.batch.retaguarda.CustoMedioScheduler;
import br.intelidata.yoda.app.batch.retaguarda.DownloadXMLScheduler;
import br.intelidata.yoda.app.batch.retaguarda.EmissaoNFeEcommerceScheduler;
import br.intelidata.yoda.app.batch.retaguarda.ExportaDocumentoXMLScheduler;
import br.intelidata.yoda.app.batch.retaguarda.ExportacaoXMLScheduler;
import br.intelidata.yoda.app.batch.retaguarda.IntegracaoAcceraScheduler;
import br.intelidata.yoda.app.batch.retaguarda.IntegracaoBancoOnlineScheduler;
import br.intelidata.yoda.app.batch.retaguarda.IntegracaoFiscalScheduler;
import br.intelidata.yoda.app.batch.retaguarda.MercaFacilScheduler;
import br.intelidata.yoda.app.batch.retaguarda.NovoECommerceScheduler;
import br.intelidata.yoda.app.batch.retaguarda.ProgramacaoPrecoGestaoScheduler;
import br.intelidata.yoda.app.batch.retaguarda.ProgramacaoPrecoScheduler;
import br.intelidata.yoda.app.batch.retaguarda.ResumoDashBoardSchedulerYoda;
import br.intelidata.yoda.app.batch.retaguarda.ResumoVendaDiariaGestaoScheduler;
import br.intelidata.yoda.app.batch.sistema.BDTuningScheduler;
import br.intelidata.yoda.app.batch.sistema.BackupYodaScheduler;
import br.intelidata.yoda.app.batch.sistema.LimparTarefasScheduler;
import br.intelidata.yoda.app.batch.sistema.R2D2Scheduler;
import br.intelidata.yoda.app.batch.sistema.SmsFilaScheduler;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TaskManagerYoda
extends AbstractTaskManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TaskServiceYoda taskServiceYoda;
    private boolean isServidorSecundario;
    @Value(value="#{'${yoda.jobids:-1}'.split(',')}")
    private List<Integer> jobIds;
    @Value(value="#{'${yoda.jobidsblacklist:-1}'.split(',')}")
    private List<Integer> jobIdsBlackList;

    public TaskManagerYoda(TaskServiceYoda taskService, BatchServiceYoda batchServiceYoda) {
        super((ITask)taskService, false, (BatchService)batchServiceYoda);
        this.taskServiceYoda = taskService;
    }

    public void initTasks() {
        this.isServidorSecundario = ControleRN.getInstance().isServidorPdvSecundario();
        this.inactiveAllRecurringJobs();
        this.taskServiceYoda.initTaskQueue();
        this.add((RecurringYodaJob)new ProcessadorTransacoesScheduler());
        this.add((RecurringYodaJob)new MonitorNfceScheduler());
        this.add((RecurringYodaJob)new ConsultaStatusServicoScheduler());
        this.add((RecurringYodaJob)new ContadorAlertasScheduler());
        this.add((RecurringYodaJob)new MonitorDotzScheduler());
        this.add((RecurringYodaJob)new MonitorMercafacilScheduler());
        this.add((RecurringYodaJob)new BackupYodaScheduler());
        this.add((RecurringYodaJob)new ExportaDocumentoXMLScheduler());
        this.add((RecurringYodaJob)new BDTuningScheduler());
        this.add((RecurringYodaJob)new ValidaReducaoZScheduler());
        this.add((RecurringYodaJob)new EnvioPendenciaNfceEmailScheduler());
        this.add((RecurringYodaJob)new ScanntechScheduler());
        this.add((RecurringYodaJob)new ScanntechCanaisVendaScheduler());
        this.add((RecurringYodaJob)new ScanntechEnvioOperacoesScheduler());
        this.add((RecurringYodaJob)new ScanntechConsultaSolicitacoesReenvioScheduler());
        this.add((RecurringYodaJob)new DownloadXMLScheduler());
        this.add((RecurringYodaJob)new ExportacaoXMLScheduler());
        this.add((RecurringYodaJob)new CatracaScheduler());
        this.add((RecurringYodaJob)new IntegracaoAcceraScheduler());
        this.add((RecurringYodaJob)new SmsFilaScheduler());
        this.add((RecurringYodaJob)new ProgramacaoPrecoScheduler());
        this.add((RecurringYodaJob)new NovoECommerceScheduler());
        this.add((RecurringYodaJob)new MercaFacilScheduler());
        this.add((RecurringYodaJob)new CustoMedioScheduler());
        this.add((RecurringYodaJob)new R2D2Scheduler());
        this.add((RecurringYodaJob)new LimparTarefasScheduler());
        this.add((RecurringYodaJob)new ContaIntegracaoScheduler());
        this.add((RecurringYodaJob)new ResumoDashBoardSchedulerYoda());
        this.add((RecurringYodaJob)new CresceVendasScheduler());
        this.add((RecurringYodaJob)new ProgramacaoPrecoGestaoScheduler());
        this.add((RecurringYodaJob)new CotacaoOnlineTomadaPrecoScheduler());
        this.add((RecurringYodaJob)new IntegracaoFiscalScheduler());
        this.add((RecurringYodaJob)new IntegracaoBancoOnlineScheduler());
        this.add((RecurringYodaJob)new ResumoVendaDiariaGestaoScheduler());
        this.add((RecurringYodaJob)new EmissaoNFeEcommerceScheduler());
        this.add((RecurringYodaJob)new ConciliacaoRecebimentoScheduler());
    }

    private void add(RecurringYodaJob job) {
        boolean possuiJobsConfigurados = (Integer)this.jobIds.get(0) != -1;
        boolean jobConfigurado = this.jobIds.stream().anyMatch(id -> job.getTipoJob().getId().equals(id));
        if ((!possuiJobsConfigurados || jobConfigurado) && job.isAtivo()) {
            if (this.isJobNaBlackList(job)) {
                this.log.info("Ignorando a tarefa '{}', porque foi configurada na blacklist (yoda.jobidsblacklist).", (Object)job.getName());
                return;
            }
            if (this.isServidorSecundario && !job.isExecutarNoServidorSecundario()) {
                this.log.info("Ignorando a tarefa '{}', porque n\u00e3o est\u00e1 habilitada para o servidor secund\u00e1rio.", (Object)job.getName());
                return;
            }
            this.excluirTarefasDuplicadasSeExistirem(job);
            try {
                this.schedule((RecurringJob)job);
            }
            catch (BatchException e) {
                this.log.error("Erro a adicionar a tarefa {}", (Object)job.getName(), (Object)e);
            }
        }
    }

    private boolean isJobNaBlackList(RecurringYodaJob job) {
        TipoJob tipoJob = job.getTipoJob();
        boolean result = this.jobIdsBlackList.contains(tipoJob.getId());
        return result;
    }

    private void excluirTarefasDuplicadasSeExistirem(RecurringYodaJob job) {
        List tasks = this.taskServiceYoda.getRecurringTasksBlocked(job.getClass().getName());
        if (tasks.size() <= 1) {
            return;
        }
        tasks.sort(Comparator.comparing(Task::getT0));
        for (int i = 0; i < tasks.size() - 1; ++i) {
            Task task = (Task)tasks.get(i);
            task.setTaskStatus(TaskStatus.FAILED);
            task.setRetorno("Tarefa duplicada");
            this.taskServiceYoda.update(task);
        }
    }
}

