/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.pdv;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.ConfiguracaoScanntech;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoScanntechCommonRN;
import br.intelidata.commons.modulo.pdv.promocaoscanntech.upload.EnvioDadosScanntech;
import br.intelidata.yoda.app.batch.RecurringYodaJob;

public class ScanntechConsultaSolicitacoesReenvioScheduler
extends RecurringYodaJob {
    private ConfiguracaoScanntech configuracao = ConfiguracaoScanntechCommonRN.getInstance().buscar(true);

    public ScanntechConsultaSolicitacoesReenvioScheduler() {
        super(Cron.dailyHour((int)12), TipoJob.SCANNTECH_CONSULTA_SOLICITACOES_REENVIO_YODA);
        this.setCronConfiguradoTelaEspecifica(true);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        if (this.isAtivo()) {
            if (this.configuracao == null) {
                this.configuracao = ConfiguracaoScanntechCommonRN.getInstance().buscarConfiguracaoValida();
            }
            Sessao sessao = Sessao.createSessao();
            new EnvioDadosScanntech(sessao, this.configuracao).consultaSolicitacoesReenvioOperacoes();
        }
    }

    public boolean isAtivo() {
        return FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SCANNTECH);
    }

    public boolean abstractControlTransaction() {
        return false;
    }
}

