/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.retaguarda;

import br.intelidata.commons.core.conciliacaorecebimento.IntegracaoConciliacaoRecebimento;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConciliacaoRecebimentoScheduler
extends RecurringYodaJob {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ConciliacaoRecebimentoScheduler() {
        super(Cron.daily((int)5), TipoJob.CONCILIACAO_RECEBIMENTO);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        if (this.isAtivo()) {
            Sessao sessao = Contexto.getInstance().getSessao();
            IntegracaoConciliacaoRecebimento integracao = new IntegracaoConciliacaoRecebimento(sessao);
            integracao.validarCadastrosAdministradoraBandeira(sessao);
            integracao.sincronizar(sessao, this.log);
        }
    }

    public boolean isAtivo() {
        return LicencaManager.getInstance().possuiLicencaConciliacaoRecebimento(Contexto.getInstance().getSessao().getFilial().getCnpj());
    }

    public boolean abstractControlTransaction() {
        return false;
    }
}

