/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.sistema;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Agendamento;
import br.intelidata.commons.domain.pojo.SMSAgendado;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.enuns.StatusAgendamento;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.c3po.sms.ISMS;
import br.intelidata.commons.modulo.c3po.sms.provedor.IProvedorSMS;
import br.intelidata.commons.modulo.c3po.sms.provedor.ProvedorSMSFactory;
import br.intelidata.commons.modulo.c3po.sms.regranegocio.SMSAgendadoRN;
import br.intelidata.commons.modulo.c3po.sms.regranegocio.UsuarioSMSRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.util.List;
import java.util.stream.Collectors;

public class SmsRelatorioScheduler
extends RecurringYodaJob {
    private Sessao sessao = Contexto.getInstance().getSessao();
    private IProvedorSMS provedorSMS = ProvedorSMSFactory.novoProvedor();

    public SmsRelatorioScheduler() {
        super(Cron.dailyMinute((int)1), TipoJob.SMS_RELATORIO_YODA);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        List idsUsuarioAgendados = SMSAgendadoRN.getInstance().buscaUsuariosAgendados().stream().map(Agendamento::getIdUsuario).collect(Collectors.toList());
        if (Util.listNullOrEmpty(idsUsuarioAgendados)) {
            return;
        }
        for (Long idUsuarioAgendado : idsUsuarioAgendados) {
            Usuario usuario = UsuarioRN.getInstance().buscarPorId(idUsuarioAgendado);
            List smss = UsuarioSMSRN.getInstance().buscarSMSPorUsuario(idUsuarioAgendado);
            for (ISMS sms : smss) {
                String celular = Util.apenasNumeros((String)usuario.getCelular());
                if (this.provedorSMS.enviar(sms.getMensagem(), celular)) {
                    this.atualizarSmsAgendado(idUsuarioAgendado.longValue(), false, "");
                    continue;
                }
                this.atualizarSmsAgendado(idUsuarioAgendado.longValue(), true, "Falha no envio.");
            }
        }
    }

    private void atualizarSmsAgendado(long idUsuario, boolean falhou, String erroDetalhes) throws UnicoMensagemUsuarioException {
        SMSAgendado smsAgendado = (SMSAgendado)SMSAgendadoRN.getInstance().buscarPorUsuario(idUsuario);
        if (smsAgendado != null) {
            smsAgendado.setDataFimExecucao(DataHoraFactory.getDataHora());
            if (falhou) {
                smsAgendado.setStatus(StatusAgendamento.FALHOU);
                smsAgendado.setErroDetalhes(erroDetalhes);
                throw new UnicoMensagemUsuarioException("YODA33", "Erro ao enviar SMS: " + erroDetalhes);
            }
            smsAgendado.setStatus(StatusAgendamento.ATIVO);
            SMSAgendadoRN.getInstance().alterar((AbstractPojo)smsAgendado, this.sessao);
        }
    }

    public boolean isAtivo() {
        return FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SMS);
    }
}

