/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.core.spring.config.oauth2;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.regranegocio.b2c.SessaoWebRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.UsuarioRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.yoda.core.spring.config.oauth2.CustomInvalidTokenExceptionYoda;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.util.JsonParser;
import org.springframework.security.oauth2.common.util.JsonParserFactory;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;

public class CustomJwtTokenStoreYoda
extends JwtTokenStore {
    private static final List<String> SESSION_SCOPE = Collections.singletonList("uniplusmobile");
    private JsonParser objectMapper = JsonParserFactory.create();
    private IConnectionHandler connectionHandler;

    public CustomJwtTokenStoreYoda(JwtAccessTokenConverter jwtTokenEnhancer, IConnectionHandler connectionHandler) {
        super(jwtTokenEnhancer);
        this.connectionHandler = connectionHandler;
    }

    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        Map info = token.getAdditionalInformation();
        String jti = info.get("jti").toString();
        if (this.isScopeSession(token)) {
            String usuario = (String)authentication.getOAuth2Request().getRequestParameters().get("username");
            String senha = (String)authentication.getOAuth2Request().getRequestParameters().get("secret");
            boolean isMobile = Boolean.parseBoolean((String)authentication.getOAuth2Request().getRequestParameters().get("mobile"));
            String userAgent = (String)authentication.getOAuth2Request().getRequestParameters().get("userAgent");
            if (Util.stringNullOrEmpty((String)userAgent)) {
                userAgent = "Yoda";
            }
            this.connectionHandler.createConnection(true);
            try {
                this.connectionHandler.beginTransaction();
                Usuario user = UsuarioRN.getInstance().validarLogin(usuario, senha, false);
                SessaoWebRN.getInstance().incluiSessaoWeb(jti, user.getId(), userAgent, isMobile);
                this.connectionHandler.commit();
            }
            catch (UnicoMensagemUsuarioException e) {
                throw new CustomInvalidTokenExceptionYoda(e.getMessage());
            }
            finally {
                this.connectionHandler.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2AccessToken readAccessToken(String tokenValue) {
        OAuth2AccessToken oAuth2AccessToken = super.readAccessToken(tokenValue);
        Map info = oAuth2AccessToken.getAdditionalInformation();
        if (this.isScopeSession(oAuth2AccessToken)) {
            String jti = info.get("jti").toString();
            this.connectionHandler.createConnection(true);
            try {
                Sessao sessao = SessaoWebRN.getInstance().buscaSessao(jti);
                if (sessao == null) {
                    throw new CustomInvalidTokenExceptionYoda("Token n\u00e3o encontrado");
                }
                ContextoHolder.setSessao((Sessao)sessao);
                ContextoHolder.setJti((String)jti);
            }
            finally {
                this.connectionHandler.releaseConnection();
            }
        }
        return oAuth2AccessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2RefreshToken readRefreshToken(String tokenValue) {
        if (tokenValue != null && !tokenValue.equals("")) {
            Jwt jwt = JwtHelper.decode((String)tokenValue);
            String claimsStr = jwt.getClaims();
            Map claims = this.objectMapper.parseMap(claimsStr);
            String jti = claims.get("ati").toString();
            this.connectionHandler.createConnection(true);
            try {
                SessaoWebRN.getInstance().apagaSessaoWeb(jti);
            }
            finally {
                this.connectionHandler.releaseConnection();
            }
        }
        return super.readRefreshToken(tokenValue);
    }

    private boolean isScopeSession(OAuth2AccessToken oAuth2AccessToken) {
        return SESSION_SCOPE.stream().anyMatch(oAuth2AccessToken.getScope()::contains);
    }
}

