SELECT
  'R'       tipo,
  ctrid 	id,
  ctrnum    documento,
  ctrtippag status,
  clicod    entidade,
  ctrdatemi emissao,
  ctrdatvnc vencimento,
  ctrdatpgt pagamento,
  ctrvlrnom valor,
  ctrvlrpag valorpago,
  ctrobs    observacao,
  CASE
      WHEN repetido.quantidade IS NULL THEN 1
      ELSE repetido.quantidade
  END quantidade
FROM contareceber
LEFT JOIN
  (SELECT ctrnum documento ,
          COUNT(ctrnum) quantidade
   FROM contareceber
   GROUP BY ctrnum
   HAVING COUNT(ctrnum) > 1) repetido ON repetido.documento = contareceber.ctrnum
UNION
SELECT
  'P'       tipo,
  ctpid 	id, 
  ctpnum    documento,
  ctptippag status,
  forcod    entidade,
  ctpdatemi emissao,
  ctpdatvnc vencimento,
  ctpdatpgt pagamento,
  ctpvlrnom valor,
  ctpvlrpag valorpago,
  ctpobs    observacao,
  CASE
       WHEN repetido.quantidade IS NULL THEN 1
       ELSE repetido.quantidade
   END quantidade
FROM contapagar
LEFT JOIN
  (SELECT forcod entidade ,
          ctpnum documento ,
          COUNT(ctpnum) quantidade
   FROM contapagar
   GROUP BY forcod,
            ctpnum
   HAVING COUNT(ctpnum) > 1) repetido ON repetido.entidade = contapagar.forcod
AND repetido.documento = contapagar.ctpnum WHERE ctpnum LIKE '%001425/001%'
