/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.atualizador;

import br.intelidata.commons.core.IconesFactory;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.util.AtualizadorBuildUtil;
import br.intelidata.commons.core.util.DownloadUtil;
import br.intelidata.commons.core.util.ListenerProgresso;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.VersaoSistema;
import br.intelidata.commons.domain.pojo.enuns.TipoEstacao;
import br.intelidata.commons.domain.pojo.enuns.TipoTratamentoErroAtualizacao;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.domain.regranegocio.VersaoSistemaRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.yoda.app.atualizador.JanelaAtualizadorVersao;
import br.intelidata.yoda.app.atualizador.componentes.YodaButtonEditor;
import br.intelidata.yoda.app.atualizador.componentes.YodaButtonRenderer;
import br.intelidata.yoda.app.atualizador.componentes.YodaDateCellRenderer;
import br.intelidata.yoda.app.atualizador.componentes.YodaJanelaProgresso;
import br.intelidata.yoda.app.atualizador.componentes.YodaTable;
import br.intelidata.yoda.app.atualizador.componentes.YodaTableModelColuna;
import br.intelidata.yoda.app.atualizador.pojo.BuildBaixada;
import br.intelidata.yoda.app.atualizador.pojo.BuildServidor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class JanelaAtualizadorVersao
extends JFrame {
    private static Logger LOGGER = LoggerFactory.getLogger(JanelaAtualizadorVersao.class);
    private JLabel labelVersaoBaixadaMaisRecente;
    private YodaTable<BuildServidor> tabelaBuildServidor;
    private YodaTable<BuildBaixada> tabelaBuildBaixada;
    private YodaTable<VersaoSistema> tabelaVersoes;
    private JComboBox<TipoTratamentoErroAtualizacao> comboTipoErro;
    private JCheckBox chkExibirMensagemErro;
    private IConnectionHandler connectionHandler;

    public JanelaAtualizadorVersao(IConnectionHandler connectionHandler) {
        super("Gerenciador de vers\u00f5es");
        this.connectionHandler = connectionHandler;
        this.setIconImage(IconesFactory.getImageIcon((String)IconesFactory.Aplicacao.ICONE_APLICACAO).getImage());
        this.setDefaultCloseOperation(2);
        this.initComponentes();
        this.setSize(655, 400);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.carregarInformacoes(false);
        this.carregarConfiguracoes();
    }

    private void initComponentes() {
        JPanel panelGeral = new JPanel(new BorderLayout(5, 5));
        panelGeral.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panelGeral.add((Component)this.getPanelTopo(), "North");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Builds", this.getPanelBuilds());
        tabbedPane.addTab("Builds instaladas", this.getPanelTableVersoes());
        tabbedPane.addTab("Configura\u00e7\u00f5es", this.getPanelConfiguracoes());
        panelGeral.add((Component)tabbedPane, "Center");
        panelGeral.add((Component)this.getPanelBotoes(), "South");
        this.getContentPane().add(panelGeral);
    }

    private JPanel getPanelTopo() {
        JPanel panelTopoEsquerdo = new JPanel();
        panelTopoEsquerdo.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panelTopoEsquerdo.add(new JLabel("Vers\u00e3o atual do sistema: " + UnicoSistema.getVersao()));
        JPanel panelTopoDireito = new JPanel(new FlowLayout(2));
        panelTopoDireito.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panelTopoDireito.add(new JLabel("Vers\u00e3o baixada mais recente do sistema: "));
        panelTopoDireito.add(this.getLabelVersaoBaixadaMaisRecente());
        JPanel panelTopo = new JPanel(new BorderLayout());
        panelTopo.setBorder(BorderFactory.createTitledBorder(""));
        panelTopo.add((Component)panelTopoEsquerdo, "West");
        panelTopo.add((Component)panelTopoDireito, "East");
        return panelTopo;
    }

    private JPanel getPanelBuilds() {
        JPanel panelTableBuildServidor = new JPanel(new BorderLayout());
        panelTableBuildServidor.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
        panelTableBuildServidor.add(new JScrollPane((Component)this.getTabelaBuildServidor()));
        JPanel panelTableBuildBaixada = new JPanel(new BorderLayout());
        panelTableBuildBaixada.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        panelTableBuildBaixada.add(new JScrollPane((Component)this.getTabelaBuildBaixada()));
        JSeparator separator = new JSeparator(1);
        separator.setBorder(BorderFactory.createTitledBorder(""));
        JPanel panelTables = new JPanel(new BorderLayout());
        panelTables.setBorder(BorderFactory.createTitledBorder(""));
        panelTables.add((Component)panelTableBuildServidor, "West");
        panelTables.add((Component)separator, "Center");
        panelTables.add((Component)panelTableBuildBaixada, "East");
        return panelTables;
    }

    private JPanel getPanelTableVersoes() {
        JPanel panelTableVersoes = new JPanel(new BorderLayout());
        panelTableVersoes.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panelTableVersoes.add(new JScrollPane((Component)this.getTabelaVersoes()));
        return panelTableVersoes;
    }

    private JPanel getPanelConfiguracoes() {
        this.comboTipoErro = new JComboBox<TipoTratamentoErroAtualizacao>(TipoTratamentoErroAtualizacao.values());
        this.comboTipoErro.setPreferredSize(new Dimension(220, 25));
        this.comboTipoErro.setSelectedIndex(0);
        this.chkExibirMensagemErro = new JCheckBox();
        JButton btnGravar = new JButton("Gravar", IconesFactory.getImageIcon((String)IconesFactory.Botoes.GRAVAR));
        btnGravar.setPreferredSize(new Dimension(90, 25));
        btnGravar.addActionListener(e -> this.gravarConfiguracoes());
        JPanel panelConfiguracao = new JPanel();
        panelConfiguracao.setLayout(new BoxLayout(panelConfiguracao, 1));
        JPanel panelCombo = new JPanel(new FlowLayout(0));
        panelCombo.add(new JLabel("Comportamento se acontecer erro ao atualizar:"));
        panelCombo.add(this.comboTipoErro);
        panelConfiguracao.add(panelCombo);
        JPanel panelChk = new JPanel(new FlowLayout(0));
        panelChk.add(new JLabel("Exibir mensagem se houver erro ao comunicar com YODA:"));
        panelChk.add(this.chkExibirMensagemErro);
        panelConfiguracao.add(panelChk);
        JPanel panelBtn = new JPanel(new FlowLayout(0));
        panelBtn.add(btnGravar);
        panelConfiguracao.add(panelBtn);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add(panelConfiguracao);
        return panel;
    }

    private void carregarConfiguracoes() {
        this.executarAcaoDB(() -> {
            this.comboTipoErro.setSelectedItem(ControleRN.getInstance().buscarTipoTratamentoErroAtualizacao());
            this.chkExibirMensagemErro.setSelected(ControleRN.getInstance().isExibirMsgFalhaConexaoYoda());
        });
    }

    private void gravarConfiguracoes() {
        this.executarAcaoDB(() -> {
            ControleRN.getInstance().setGravarDadosGerenciadorAtualizacao(null, (TipoTratamentoErroAtualizacao)this.comboTipoErro.getSelectedItem(), this.chkExibirMensagemErro.isSelected());
            JOptionPane.showMessageDialog((Component)this, "Configura\u00e7\u00f5es salvas com sucesso", "YODA", 1);
        });
    }

    private JPanel getPanelBotoes() {
        JButton botaoSair = new JButton("Sair");
        botaoSair.setToolTipText("Fecha a janela");
        botaoSair.setIcon(IconesFactory.getImageIcon((String)IconesFactory.Botoes.FECHAR));
        botaoSair.addActionListener(e -> this.dispose());
        JButton botaoAtualizar = new JButton("Renovar informa\u00e7\u00f5es da tela");
        botaoAtualizar.setToolTipText("Atualiza as informa\u00e7\u00f5es das grids 'Builds dispon\u00edveis', 'Builds baixadas' e 'Builds instaladas'");
        botaoAtualizar.setIcon(IconesFactory.getImageIcon((String)IconesFactory.Botoes.PROCESSAR));
        botaoAtualizar.addActionListener(e -> {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.carregarInformacoes(true);
            this.setCursor(Cursor.getDefaultCursor());
        });
        JButton botaoUploadManual = new JButton("Upload manual");
        botaoUploadManual.setToolTipText("Selecione uma build Uniplus para ser disponibilizada no servidor Yoda para atualiza\u00e7\u00e3o pelas esta\u00e7\u00f5es da sua rede");
        botaoUploadManual.setIcon(IconesFactory.getImageIcon((String)IconesFactory.Botoes.UP));
        botaoUploadManual.addActionListener(e -> {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.uploadManual();
            this.setCursor(Cursor.getDefaultCursor());
        });
        JPanel panelBotoes = new JPanel(new FlowLayout(2));
        panelBotoes.setBorder(BorderFactory.createTitledBorder(""));
        panelBotoes.add(botaoUploadManual);
        panelBotoes.add(botaoAtualizar);
        panelBotoes.add(botaoSair);
        return panelBotoes;
    }

    private JLabel getLabelVersaoBaixadaMaisRecente() {
        if (this.labelVersaoBaixadaMaisRecente == null) {
            this.labelVersaoBaixadaMaisRecente = new JLabel("");
        }
        return this.labelVersaoBaixadaMaisRecente;
    }

    private YodaTable<BuildBaixada> getTabelaBuildBaixada() {
        if (this.tabelaBuildBaixada == null) {
            ArrayList<YodaTableModelColuna> colunas = new ArrayList<YodaTableModelColuna>();
            colunas.add(new YodaTableModelColuna("descricao", "Builds baixadas", 200));
            YodaTableModelColuna colunaBotao = new YodaTableModelColuna("btn", "Atualizar", 10, (TableCellRenderer)new YodaButtonRenderer(IconesFactory.Botoes.REFRESH, "Atualiza a build no servidor"), (TableCellEditor)new YodaButtonEditor(arg_0 -> this.atualizarVersao(arg_0), IconesFactory.Botoes.REFRESH));
            colunaBotao.setBinding(false);
            colunas.add(colunaBotao);
            this.tabelaBuildBaixada = new YodaTable(colunas);
            this.tabelaBuildBaixada.setPreferredScrollableViewportSize(new Dimension(300, 200));
        }
        return this.tabelaBuildBaixada;
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="Reiniciar o sistema.")
    private void atualizarVersao(ActionEvent evt) {
        Integer linha = (Integer)evt.getSource();
        BuildBaixada buildBaixada = (BuildBaixada)this.getTabelaBuildBaixada().getObjeto(linha.intValue());
        if (buildBaixada != null) {
            String destino = Util.getDiretorioAplicacao();
            String nomeArquivoMD5 = buildBaixada.getCaminho().replace(".zip", ".md5");
            File arquivoMD5 = new File(nomeArquivoMD5);
            if (arquivoMD5.exists()) {
                String md5Arquivo;
                String md5 = Util.file2String((File)arquivoMD5);
                if (!md5.equalsIgnoreCase(md5Arquivo = Util.getMd5String((String)buildBaixada.getCaminho()))) {
                    JOptionPane.showMessageDialog((Component)this, "O arquivo de atualiza\u00e7\u00e3o Uniplus", "YODA", 0);
                    return;
                }
            } else {
                JOptionPane.showMessageDialog((Component)this, "N\u00e3o foi poss\u00edvel localizar o arquivo MD5 do arquivo de atualiza\u00e7\u00e3o Uniplus", "YODA", 0);
                return;
            }
            if (AtualizadorBuildUtil.unzipUpdaterJar((String)buildBaixada.getCaminho(), (String)destino)) {
                Object[] opcoes = new String[]{"Continuar com a atualiza\u00e7\u00e3o", "Cancelar"};
                int resposta = JOptionPane.showOptionDialog((Component)this, "Antes de iniciar a atualiza\u00e7\u00e3o verifique se o Uniplus ou qualquer outro processo da fam\u00edlia Uniplus est\u00e1 aberto." + Util.newLine() + "Caso esteja, feche o processo em quest\u00e3o e inicie a atualiza\u00e7\u00e3o novamente. (YODAY14)", "YODA", 1, 3, null, opcoes, opcoes[0]);
                if (resposta == 0) {
                    Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                        try {
                            String comando = "\"" + destino + "\\jre\\bin\\javaw.exe\" -jar \"" + destino + "\\updater.jar\" \"" + buildBaixada.getCaminho() + "\" \"" + destino + "\\Yoda.exe\" \"" + TipoEstacao.YODA.getId() + "\"";
                            LOGGER.info("Comando " + comando);
                            new ProcessBuilder(comando).inheritIO().start();
                        }
                        catch (Throwable ex) {
                            LOGGER.error("N\u00e3o foi poss\u00edvel executar o updater", ex);
                        }
                    }));
                    System.exit(0);
                }
            }
        }
    }

    private YodaTable<BuildServidor> getTabelaBuildServidor() {
        if (this.tabelaBuildServidor == null) {
            ArrayList<YodaTableModelColuna> colunas = new ArrayList<YodaTableModelColuna>();
            colunas.add(new YodaTableModelColuna("descricao", "Builds dispon\u00edveis", 200));
            YodaTableModelColuna colunaBotao = new YodaTableModelColuna("btn", "Baixar", 10, (TableCellRenderer)new YodaButtonRenderer(IconesFactory.Botoes.DOWN, "Baixa a build do servidor de downloads Uniplus"), (TableCellEditor)new YodaButtonEditor(arg_0 -> this.baixarVersao(arg_0), IconesFactory.Botoes.DOWN));
            colunaBotao.setBinding(false);
            colunas.add(colunaBotao);
            this.tabelaBuildServidor = new YodaTable(colunas);
            this.tabelaBuildServidor.setPreferredScrollableViewportSize(new Dimension(300, 200));
        }
        return this.tabelaBuildServidor;
    }

    private YodaTable<VersaoSistema> getTabelaVersoes() {
        if (this.tabelaVersoes == null) {
            ArrayList<YodaTableModelColuna> colunas = new ArrayList<YodaTableModelColuna>();
            colunas.add(new YodaTableModelColuna("ip", "IP", 80));
            colunas.add(new YodaTableModelColuna("nomeEstacao", "Esta\u00e7\u00e3o", 100));
            colunas.add(new YodaTableModelColuna("tipoEstacao", "Sistema", 90));
            colunas.add(new YodaTableModelColuna("build", "Build", 40));
            colunas.add(new YodaTableModelColuna("dataHoraAtualizacao", "\u00daltima atualiza\u00e7\u00e3o", 100, (TableCellRenderer)new YodaDateCellRenderer()));
            colunas.add(new YodaTableModelColuna("dataHoraUltimaVerificacao", "\u00daltima verifica\u00e7\u00e3o", 100, (TableCellRenderer)new YodaDateCellRenderer()));
            this.tabelaVersoes = new YodaTable(colunas);
            this.tabelaVersoes.setPreferredScrollableViewportSize(new Dimension(700, 200));
        }
        return this.tabelaVersoes;
    }

    private void uploadManual() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileNameExtensionFilter("Arquivo de atualiza\u00e7\u00e3o Uniplus", "zip"));
        chooser.setAcceptAllFileFilterUsed(false);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            File zip = chooser.getSelectedFile();
            if (!AtualizadorBuildUtil.isArquivoAtualizacaoValido((File)zip)) {
                JOptionPane.showMessageDialog((Component)this, "O arquivo selecionado n\u00e3o \u00e9 um arquivo de atualiza\u00e7\u00e3o Uniplus v\u00e1lido. Verifique", "YODA", 2);
            } else {
                try {
                    String destino = Util.getDiretorioAplicacao() + "/builds_baixadas/" + zip.getName();
                    Files.copy(zip.toPath(), Paths.get(destino, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                    String md5Arquivo = Util.getMd5String((String)destino);
                    Util.salvarStringEmArquivo((String)md5Arquivo, (String)(Util.getDiretorioAplicacao() + "/builds_baixadas/" + zip.getName().replace(".zip", ".md5")));
                    this.carregarBuildsBaixadas();
                }
                catch (Throwable ex) {
                    JOptionPane.showMessageDialog((Component)this, "N\u00e3o foi poss\u00edvel copiar o arquivo de atualiza\u00e7\u00e3o Uniplus\r" + ex.getMessage(), "YODA", 0);
                }
            }
        }
    }

    private void baixarVersao(ActionEvent evt) {
        Integer linha = (Integer)evt.getSource();
        BuildServidor buildServidor = (BuildServidor)this.getTabelaBuildServidor().getObjeto(linha.intValue());
        if (buildServidor != null) {
            String nomeArquivo = buildServidor.getLink().substring(buildServidor.getLink().lastIndexOf("/") + 1);
            String destino = Util.getDiretorioAplicacao() + "/builds_baixadas/" + nomeArquivo;
            YodaJanelaProgresso janelaProgresso = new YodaJanelaProgresso();
            DownloadUtil downloadUtil = new DownloadUtil();
            downloadUtil.download((ListenerProgresso)janelaProgresso, buildServidor.getLink(), destino);
            janelaProgresso.setVisible(true);
            File arquivo = new File(destino);
            if (arquivo.exists() && !this.isMd5ArquivoValido(buildServidor, arquivo)) {
                if (!arquivo.delete()) {
                    LOGGER.info("N\u00e3o foi poss\u00edvel excluir o arquivo");
                }
                JOptionPane.showMessageDialog((Component)this, "N\u00e3o foi poss\u00edvel baixar o arquivo " + nomeArquivo, "YODA", 1);
            }
            this.carregarInformacoes(false);
        }
    }

    private boolean isMd5ArquivoValido(BuildServidor buildServidor, File arquivo) {
        try {
            String md5Arquivo = Util.getMd5String((File)arquivo);
            if (md5Arquivo.equalsIgnoreCase(buildServidor.getMd5())) {
                String nomeArquivo = buildServidor.getLink().substring(buildServidor.getLink().lastIndexOf("/") + 1).replace(".zip", ".md5");
                Util.salvarStringEmArquivo((String)md5Arquivo, (String)(Util.getDiretorioAplicacao() + "/builds_baixadas/" + nomeArquivo));
                return true;
            }
            return false;
        }
        catch (UnicoMensagemUsuarioException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private void carregarBuildsBaixadas() {
        String nomeDirBuilds = Util.getDiretorioAplicacao() + "/builds_baixadas";
        File dirBuilds = new File(nomeDirBuilds);
        if (!dirBuilds.exists()) {
            if (!dirBuilds.mkdirs()) {
                LOGGER.error("Erro ao criar os diret\u00f3rios");
            }
        } else {
            this.getTabelaBuildBaixada().getModelo().clear();
            try (Stream<Path> paths = Files.list(Paths.get(nomeDirBuilds, new String[0]));){
                List baixados = paths.filter(p -> p.toString().endsWith(".zip")).map(arg_0 -> this.path2BuildBaixada(arg_0)).sorted(Comparator.comparing(buildBaixada -> buildBaixada != null ? buildBaixada.getVersao() : 0L).reversed()).collect(Collectors.toList());
                this.getTabelaBuildBaixada().getModelo().setFonteDados(baixados);
                this.getTabelaBuildBaixada().fireTableDataChanged();
            }
            catch (Throwable ex) {
                throw new UnicoException("COM236440", "N\u00e3o foi poss\u00edvel carregar os arquivos baixados", ex);
            }
        }
    }

    private BuildBaixada path2BuildBaixada(Path path) {
        String descricao = path.getFileName().toString().substring(0, path.getFileName().toString().lastIndexOf("."));
        long versao = Util.converteVersao((String)descricao.substring(descricao.indexOf("_") + 1));
        descricao = StringUtils.capitalize((String)descricao).replace("_", " ");
        return new BuildBaixada(descricao, path.toString(), versao, "");
    }

    private void carregarBuildsDisponiveis() {
        this.getTabelaBuildServidor().getModelo().clear();
        String uri = this.getEnderecoWS() + "/uniplus/builds";
        ClientCredentialsResourceDetails resource = new ClientCredentialsResourceDetails();
        resource.setAccessTokenUri(this.getEnderecoWS() + "/oauth/token");
        resource.setClientId("uniplus");
        resource.setClientSecret("l4gtr1ck2rspr3ngcl3ent");
        OAuth2RestTemplate restTemplate = new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)resource);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.APPLICATION_JSON_UTF8);
        httpHeaders.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON_UTF8));
        HttpEntity entityCredentials = new HttpEntity((MultiValueMap)httpHeaders);
        try {
            List dados;
            ResponseEntity response = restTemplate.exchange(uri, HttpMethod.GET, entityCredentials, List.class, new Object[0]);
            if (response != null && (dados = (List)response.getBody()) != null) {
                dados.stream().map(item -> {
                    Map map = item;
                    BuildServidor buildServidor = new BuildServidor();
                    buildServidor.setLink(this.getLinkBuild((String)map.get("build")));
                    buildServidor.setBuild(Util.converteVersao((String)((String)map.get("build"))));
                    buildServidor.setDescricao("Uniplus " + (String)map.get("build"));
                    buildServidor.setMd5((String)map.get("md5"));
                    return buildServidor;
                }).sorted(Comparator.comparing(BuildServidor::getBuild).reversed()).forEach(b -> this.getTabelaBuildServidor().adicionar(b));
            }
        }
        catch (Throwable ex) {
            LOGGER.error(ex.getMessage(), ex);
        }
    }

    private void carregarInformacoes(boolean exibirMensagem) {
        new Thread(() -> {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.carregarBuildsBaixadas();
            this.carregarBuildsDisponiveis();
            this.carregarVersoesInstaladas();
            if (this.getTabelaBuildBaixada().getFonteDados().size() > 0) {
                String versao = ((BuildBaixada)this.getTabelaBuildBaixada().getFonteDados().get(0)).getDescricao().replace("Uniplus ", "");
                this.getLabelVersaoBaixadaMaisRecente().setText(versao);
            }
            this.setCursor(Cursor.getDefaultCursor());
            if (exibirMensagem) {
                JOptionPane.showMessageDialog((Component)this, "Informa\u00e7\u00f5es atualizadas com sucesso", "YODA", 1);
            }
        }).start();
    }

    private void carregarVersoesInstaladas() {
        this.executarAcaoDB(() -> {
            this.getTabelaVersoes().getFonteDados().clear();
            this.getTabelaVersoes().getFonteDados().addAll(VersaoSistemaRN.getInstance().buscarLista());
            this.getTabelaVersoes().fireTableDataChanged();
        });
    }

    private void executarAcaoDB(ExecutarAcaoDB executarAcaoDB) {
        this.connectionHandler.createConnection(true);
        try {
            executarAcaoDB.executar();
        }
        catch (Throwable ex) {
            LOGGER.error(ex.getMessage(), ex);
        }
        finally {
            this.connectionHandler.releaseConnection();
        }
    }

    private String getEnderecoWS() {
        String end = Contexto.getInstance().getProperties().getProperty("ws.novo.url");
        if (Util.stringNullOrEmpty((String)end)) {
            end = "https://canal.intelidata.inf.br";
        }
        return end;
    }

    private String getLinkBuild(String versao) {
        String urlBase = Contexto.getInstance().getProperties().getProperty("urlbase.download.build");
        if (Util.stringNullOrEmpty((String)urlBase)) {
            urlBase = "https://builds.unipluscdn.com/uniplusdesktop";
        }
        return urlBase + "/uniplus_" + versao + ".zip";
    }
}

