/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.retaguarda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.licenca.ProdutoLicenca;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.cotacaoonline.CotacaoOnlineRNSimplificada;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CotacaoOnlineTomadaPrecoScheduler
extends RecurringYodaJob {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public CotacaoOnlineTomadaPrecoScheduler() {
        super(Cron.every30minutes(), TipoJob.COTACAO_ONLINE_IMPORTACAO_TOMADA_PRECO);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        if (this.isAtivo()) {
            Sessao sessao = Sessao.createSessao();
            CotacaoOnlineRNSimplificada.getInstance().importarTomadaPrecoCotacaoOnline(sessao, null, null, this.log);
        }
    }

    public boolean isAtivo() {
        return LicencaManager.getInstance().contemLicenca(ProdutoLicenca.COTACAO_ONLINE);
    }

    public boolean abstractControlTransaction() {
        return false;
    }
}

