/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.sistema;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.SqlNativo;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Controle;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;

public class BDTuningScheduler
extends RecurringYodaJob {
    private Sessao sessao = Contexto.getInstance().getSessao();

    public BDTuningScheduler() {
        super(Cron.daily((int)3), TipoJob.BD_TUNING_YODA);
        this.setCronConfiguradoTelaEspecifica(true);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        LocalDate hoje = DataHoraFactory.getData();
        LocalDate dataUltimoVacuumFull = ControleRN.getInstance().buscar().getDataUltimoVacuumFull();
        boolean full = dataUltimoVacuumFull == null || ChronoUnit.DAYS.between(dataUltimoVacuumFull, hoje) > 15L;
        String comando = full ? "VACUUM FULL" : "VACUUM ANALYZE";
        SqlNativo sql = new SqlNativo(comando);
        sql.executaUpdate();
        sql.close();
        if (full) {
            Controle controle = ControleRN.getInstance().buscar();
            controle.setDataUltimoVacuumFull(hoje);
            ControleRN.getInstance().alterar((AbstractPojo)controle, this.sessao);
        }
    }

    public boolean isAtivo() {
        return !this.getCronExpression().isEmpty() && PropriedadeRN.getInstance().getPropriedadeBoolean(this.sessao.getFilial(), 626);
    }

    public String getCronExpression() {
        return this.toDailyCron(PropriedadeRN.getInstance().getPropriedadeString(this.sessao.getFilial(), 625));
    }
}

