/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.core.spring.aop;

import br.intelidata.core.aop.DBTransactionExecutor;
import br.intelidata.core.sgdb.IConnectionHandler;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DBTransactionYoda
implements DBTransactionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBTransactionYoda.class);
    private final IConnectionHandler connectionHandler;

    @Autowired
    public DBTransactionYoda(IConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    public Object dbTransaction(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object value;
        this.connectionHandler.createConnection(false);
        try {
            this.connectionHandler.beginTransaction();
            value = proceedingJoinPoint.proceed();
            this.connectionHandler.commit();
        }
        catch (Throwable e) {
            LOGGER.error("#YODA", e);
            this.connectionHandler.rollback();
            throw e;
        }
        finally {
            this.connectionHandler.releaseConnection();
        }
        return value;
    }
}

