SELECT documento_pagar.id_documento_pagar id,
       tipo_documento_financeiro.nome tipodocumento ,
       'P' tipo ,
       id_entidade entidade ,
       data_emissao emissao ,
       data_vencimento vencimento ,
       data_quitacao pagamento ,
       valor ,
       saldo ,
       situacao status ,
       numero_documento_pagar documento ,
       descricao historico ,
       CASE
           WHEN repetido.quantidade IS NULL THEN 1
           ELSE repetido.quantidade
       END quantidade
FROM dbo.documento_pagar
LEFT JOIN tipo_documento_financeiro ON tipo_documento_financeiro.id_tipo_documento_financeiro = documento_pagar.id_tipo_documento_financeiro
LEFT JOIN
  (SELECT id_entidade entidade ,
          numero_documento_pagar documento ,
          COUNT(numero_documento_pagar) quantidade
   FROM dbo.documento_pagar
   WHERE situacao <> 3
   GROUP BY id_entidade,
            numero_documento_pagar
   HAVING COUNT(numero_documento_pagar) > 1) repetido ON repetido.entidade = documento_pagar.id_entidade
AND repetido.documento = documento_pagar.numero_documento_pagar
WHERE situacao <> 3
UNION
SELECT documento_receber.id_documento_receber id,
       tipo_documento_financeiro.nome tipodocumento ,
       'R' tipo ,
       id_entidade entidade ,
       data_emissao emissao ,
       data_vencimento vencimento ,
       data_quitacao pagamento ,
       valor ,
       saldo ,
       situacao status ,
       numero_documento_receber documento ,
       descricao historico ,
       CASE
           WHEN repetido.quantidade IS NULL THEN 1
           ELSE repetido.quantidade
       END quantidade
FROM dbo.documento_receber
LEFT JOIN tipo_documento_financeiro ON tipo_documento_financeiro.id_tipo_documento_financeiro = documento_receber.id_tipo_documento_financeiro
LEFT JOIN
  (SELECT numero_documento_receber documento ,
          COUNT(numero_documento_receber) quantidade
   FROM dbo.documento_receber
   WHERE situacao <> 3
   GROUP BY numero_documento_receber
   HAVING COUNT(numero_documento_receber) > 1) repetido ON repetido.documento = documento_receber.numero_documento_receber
WHERE situacao <> 3