/*
 * Decompiled with CFR 0.152.
 */
package restart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import restart.JanelaProgresso;

public class Atualizador {
    private static final Logger log = Logger.getLogger("updater");

    public static void main(String[] args) {
        try {
            FileHandler fh = new FileHandler("log/updater.log", true);
            fh.setFormatter(new SimpleFormatter());
            log.addHandler(fh);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (args.length > 0) {
            try {
                for (String arg : args) {
                    log.info("Par\u00e2metro: " + arg);
                }
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                final String nomeZip = args[0];
                String exeReinicio = args[1];
                Integer idTipoEstacao = Integer.valueOf(args[2]);
                String urlYoda = null;
                if (args.length == 5) {
                    urlYoda = "https://" + args[3] + ":" + args[4];
                }
                final JanelaProgresso janelaProgresso = new JanelaProgresso();
                janelaProgresso.setTitle("Atualizando o sistema");
                janelaProgresso.setProgressoIndeterminado(true);
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() {
                        Atualizador.unzip(nomeZip);
                        return null;
                    }

                    @Override
                    protected void done() {
                        janelaProgresso.fechar();
                    }
                }.execute();
                janelaProgresso.setVisible(true);
                String nomeExe = exeReinicio.toLowerCase();
                if (nomeExe.contains("\\")) {
                    nomeExe = nomeExe.substring(nomeExe.lastIndexOf("\\") + 1);
                } else if (nomeExe.contains("/")) {
                    nomeExe = nomeExe.substring(nomeExe.lastIndexOf("/") + 1);
                }
                log.info("Atualizando base de dados");
                Atualizador.atualizarBase(nomeExe.contains("yoda"), idTipoEstacao, urlYoda);
                String nomeExeReinicio = exeReinicio.substring(exeReinicio.lastIndexOf("\\") + 1);
                JOptionPane.showMessageDialog(null, "Atualiza\u00e7\u00e3o realizada com sucesso. Ap\u00f3s pressionar OK, aguarde um momento enquanto o " + nomeExeReinicio + " reinicia. (YODAM15)", "Uniplus", 1);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    try {
                        log.info("Iniciando " + exeReinicio);
                        new ProcessBuilder("\"" + exeReinicio + "\"").inheritIO().start();
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, "Erro ao iniciar o " + exeReinicio, ex);
                    }
                }));
                log.info("Fechando o atualizador");
                System.exit(0);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Erro ao atualizar", ex);
            }
        }
    }

    private static void unzip(String zipFilePath) {
        String destino = System.getProperty("user.dir");
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("sun.arch.data.model");
        String path = osName.contains("windows") ? "win" : (osName.contains("linux") ? "linux" : "");
        path = path + (osArch.toLowerCase().contains("64") ? "/64/" : "/32/");
        try (ZipFile zipFile = new ZipFile(zipFilePath);){
            Enumeration<? extends ZipEntry> enu = zipFile.entries();
            while (enu.hasMoreElements()) {
                File file;
                ZipEntry zipEntry = enu.nextElement();
                String name = zipEntry.getName();
                if (name.equalsIgnoreCase("updater.jar")) continue;
                if (name.startsWith("arquivos")) {
                    if (!name.startsWith("arquivos/" + path) || zipEntry.isDirectory()) continue;
                    file = new File(destino + "/" + name);
                    if (!file.exists()) {
                        Atualizador.extrair(zipFile, zipEntry, destino);
                        continue;
                    }
                    boolean atualizar = !name.contains("nao_sobrescrever") && file.length() != zipEntry.getSize();
                    if (!atualizar) continue;
                    Atualizador.extrair(zipFile, zipEntry, destino);
                    continue;
                }
                if (zipEntry.isDirectory() && (file = new File(destino + "/" + name)).mkdirs()) {
                    log.log(Level.INFO, "N\u00e3o foi poss\u00edvel criar a pasta " + destino + "/" + name);
                }
                Atualizador.extrair(zipFile, zipEntry, destino);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "N\u00e3o foi poss\u00edvel extrair o arquivo zip", e);
        }
    }

    private static void extrair(ZipFile zipFile, ZipEntry zipEntry, String destino) {
        File file;
        String name = zipEntry.getName();
        if (name.equalsIgnoreCase("dashboard-1.0.jar") && !(file = new File((destino = destino + File.separator + "dashboard") + File.separator + name)).exists()) {
            return;
        }
        try (InputStream is = zipFile.getInputStream(zipEntry);){
            File f;
            log.info("Extraindo " + name);
            if (name.contains("/")) {
                name = name.substring(name.lastIndexOf("/") + 1);
            }
            if ((f = new File(destino + "/" + name)).exists()) {
                boolean excluiu;
                while (!(excluiu = Atualizador.excluirArquivo(f))) {
                    String nomeArquivo = Atualizador.getNomeArquivo(name);
                    String msg = String.join((CharSequence)"", "N\u00e3o foi poss\u00edvel atualizar o Uniplus porque o ", nomeArquivo, " est\u00e1 sendo executado.\nFeche o ", nomeArquivo, " e tente novamente. (YODAM16)");
                    int resposta = JOptionPane.showOptionDialog(null, msg, "Uniplus", 2, 2, null, new String[]{"Tentar novamente", "Cancelar"}, "Tentar novamente");
                    if (resposta != 1) continue;
                    System.exit(1);
                }
            }
            Files.copy(is, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, "N\u00e3o foi poss\u00edvel extrair o arquivo zip", ex);
        }
    }

    private static String getNomeArquivo(String a) {
        int idx = a.lastIndexOf(".");
        return idx > -1 ? a.substring(0, idx).toUpperCase() : a;
    }

    private static boolean excluirArquivo(File f) {
        int tentativas = 3;
        boolean excluiu = false;
        for (int i = 0; i < tentativas; ++i) {
            try {
                log.info("Excluindo o arquivo " + f.getPath() + " tentativa " + (i + 1));
                Files.delete(f.toPath());
                excluiu = true;
                break;
            }
            catch (Throwable ex) {
                log.log(Level.SEVERE, "N\u00e3o foi poss\u00edvel excluir o arquivo " + f.getPath(), ex);
                try {
                    Thread.sleep(2500L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                continue;
            }
        }
        return excluiu;
    }

    private static void atualizarBase(boolean servidor, int idTipoEstacao, String urlYoda) {
        try (URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();){
            File file = new File("uniplus.jar");
            URL url = file.toURI().toURL();
            Method methodAddUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            methodAddUrl.setAccessible(true);
            methodAddUrl.invoke((Object)classLoader, url);
            Class<?> c = classLoader.loadClass("br.intelidata.desktop.util.AtualizarBaseAtualizador");
            Object obj = c.newInstance();
            for (Method method : obj.getClass().getMethods()) {
                if (!method.getName().equalsIgnoreCase("atualizar")) continue;
                method.setAccessible(true);
                method.invoke(obj, servidor, idTipoEstacao, urlYoda);
            }
        }
        catch (Throwable ex) {
            log.log(Level.SEVERE, "N\u00e3o foi poss\u00edvel atualizar a base de dados", ex);
        }
    }
}

