/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.atualizador;

import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.DadosControleServidor;
import br.intelidata.commons.domain.pojo.VersaoSistema;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.domain.regranegocio.VersaoSistemaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.sgdb.IConnectionHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/atualizador/"})
public class AtualizadorBuildController {
    private IConnectionHandler connectionHandler;

    @Autowired
    public AtualizadorBuildController(IConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequestMapping(value={"habilitado"})
    public boolean isHabilitado() {
        Path dirBuilds = Paths.get(Util.getDiretorioAplicacao() + "/builds_baixadas", new String[0]);
        try (Stream<Path> paths = Files.list(dirBuilds);){
            boolean bl = Files.exists(dirBuilds, new LinkOption[0]) && paths.findAny().isPresent();
            return bl;
        }
        catch (IOException ex) {
            throw new UnicoException("YODA17", (Throwable)ex);
        }
    }

    @RequestMapping(value={"dados"})
    @DBAutoCommit
    public DadosControleServidor getDadosControleServidor() {
        DadosControleServidor dadosControleServidor = new DadosControleServidor();
        dadosControleServidor.setBuildSistema(ControleRN.getInstance().buscarBuildSistema());
        dadosControleServidor.setTipoTratamentoErroAtualizacao(ControleRN.getInstance().buscarTipoTratamentoErroAtualizacao());
        dadosControleServidor.setExibirMsgFalhaConexaoYoda(ControleRN.getInstance().isExibirMsgFalhaConexaoYoda());
        return dadosControleServidor;
    }

    @RequestMapping(value={"gravarVersaoSistemaVerificacao"}, method={RequestMethod.POST})
    public String gravarVersaoSistemaVerificacao(@RequestBody VersaoSistema versaoSistema) throws UnicoMensagemUsuarioException {
        this.connectionHandler.createConnection(true);
        VersaoSistemaRN.getInstance().gravarDataUltimaVerificacao(null, versaoSistema.getIp(), versaoSistema.getNomeEstacao(), versaoSistema.getBuild(), versaoSistema.getTipoEstacao(), DataHoraFactory.getDataHora());
        this.connectionHandler.releaseConnection();
        return "OK";
    }

    @RequestMapping(value={"gravarVersaoSistemaAtualizacao"}, method={RequestMethod.POST})
    public String gravarVersaoSistemaAtualizacao(@RequestBody VersaoSistema versaoSistema) throws UnicoMensagemUsuarioException {
        this.connectionHandler.createConnection(true);
        VersaoSistemaRN.getInstance().gravarDataAtualizacao(null, versaoSistema.getIp(), versaoSistema.getNomeEstacao(), versaoSistema.getBuild(), versaoSistema.getTipoEstacao(), DataHoraFactory.getDataHora());
        this.connectionHandler.releaseConnection();
        return "OK";
    }

    @RequestMapping(value={"/existeBuild/{build}"}, method={RequestMethod.GET})
    public Object existeBuild(@PathVariable(value="build") String build) {
        Path dirBuilds = Paths.get(Util.getDiretorioAplicacao() + "/builds_baixadas/uniplus_" + build + ".zip", new String[0]);
        return Files.exists(dirBuilds, new LinkOption[0]);
    }
}

