/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch;

import br.intelidata.api.batch.AbstractTaskManager;
import br.intelidata.api.batch.AbstractTaskProcessor;
import br.intelidata.api.batch.ITask;
import br.intelidata.commons.core.client.batch.TaskRequest;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.UnicoProperties;
import br.intelidata.commons.core.util.Util;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.yoda.app.batch.TaskManagerYoda;
import br.intelidata.yoda.app.batch.TaskServiceYoda;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.PostConstruct;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TaskProcessorYoda
extends AbstractTaskProcessor {
    private final IConnectionHandler ch;
    private final TaskManagerYoda taskManagerYoda;
    private final TaskServiceYoda taskServiceYoda;
    private boolean iniciado;

    public TaskProcessorYoda(TaskManagerYoda taskManager, TaskServiceYoda taskService, IConnectionHandler ch) {
        super((AbstractTaskManager)taskManager, (ITask)taskService);
        this.taskManagerYoda = taskManager;
        this.taskServiceYoda = taskService;
        this.ch = ch;
        UnicoProperties properties = Contexto.getInstance().getProperties();
        this.cpuMaxLimit = Util.string2int((String)properties.getProperty("yoda.taskmanager.cpumaxlimit"));
        this.threads = Util.string2int((String)properties.getProperty("yoda.taskmanager.thread"));
    }

    @PostConstruct
    public void postConstruct() {
        this.createConnection(() -> ((TaskManagerYoda)this.taskManagerYoda).initTasks());
        this.iniciado = true;
        super.postConstruct();
    }

    @Scheduled(fixedDelay=5000L)
    public void pop() {
        this.createConnection(() -> super.pop());
    }

    private void createConnection(Runnable runner) {
        try {
            this.ch.createConnection(true);
            runner.run();
        }
        catch (Throwable e) {
            throw new UnicoException("COM23669798", e);
        }
        finally {
            this.ch.releaseConnection();
        }
    }

    public int getThreads() {
        return this.threads;
    }

    public int getThreadsDisponiveis() {
        return this.threads - this.threadPoolExecutor.getActiveCount();
    }

    public long getTempoExecucao() {
        return Duration.between(this.startUp, Instant.now()).toMillis();
    }

    public TaskServiceYoda getTaskServiceYoda() {
        return this.taskServiceYoda;
    }

    public TaskManagerYoda getTaskManagerYoda() {
        return this.taskManagerYoda;
    }

    public boolean isIniciado() {
        return this.iniciado;
    }

    public void pausar(TaskRequest request) throws UnicoMensagemUsuarioException {
        this.lancaExcecaoSeNaoFoiIniciado();
        this.taskServiceYoda.pausar(request);
    }

    public void pausarScheduler(TaskRequest request) throws UnicoMensagemUsuarioException {
        this.lancaExcecaoSeNaoFoiIniciado();
        this.taskServiceYoda.pausarScheduler(request);
    }

    public void iniciar(TaskRequest request) throws UnicoMensagemUsuarioException {
        this.lancaExcecaoSeNaoFoiIniciado();
        this.taskServiceYoda.iniciar(request);
    }

    public void alterarCron(TaskRequest request) throws UnicoMensagemUsuarioException {
        this.lancaExcecaoSeNaoFoiIniciado();
        this.taskServiceYoda.alterarCron(request);
    }

    private void lancaExcecaoSeNaoFoiIniciado() throws UnicoMensagemUsuarioException {
        if (!this.iniciado) {
            throw new UnicoMensagemUsuarioException("YODA40", "O Gerenciador de processos do Yoda ainda n\u00e3o foi inicializado");
        }
    }
}

