/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.pdv;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Email;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.pdv.promocaoscanntech.relatorio.PendenciasNfceRelatorioParaEmail;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.io.File;
import java.time.temporal.Temporal;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;

public class EnvioPendenciaNfceEmailScheduler
extends RecurringYodaJob {
    private Sessao sessao = Contexto.getInstance().getSessao();

    public EnvioPendenciaNfceEmailScheduler() {
        super(Cron.daily((int)3), TipoJob.ENVIO_PENDENCIA_NFCE_EMAIL_YODA);
        this.setCronConfiguradoTelaEspecifica(true);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        Remessa remessa = new PendenciasNfceRelatorioParaEmail().getRelatorio();
        if (remessa == null) {
            this.getTask().setRetorno("Sem pend\u00eancias para enviar por e-mail.");
            return;
        }
        File pdfFile = (File)remessa.getMalote().get("pdf");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(Util.file2ByteArray((File)pdfFile), "application/pdf");
        dataSource.setName("Pendencias_NFC_e.pdf");
        String assunto = "Pend\u00eancias NFC-e";
        String mensagem = "Segue em anexo o relat\u00f3rio de pend\u00eancias NFC-e gerado em " + Util.formataDataHora((Temporal)DataHoraFactory.getDataHora(), (String)"dd/MM/yyyy HH:mm");
        DataSource[] anexo = new DataSource[]{dataSource};
        int numEmailsEnviados = 0;
        for (Filial filial : FilialRN.getInstance().buscarLista()) {
            String email = PropriedadeRN.getInstance().getPropriedadeString(filial, 741);
            if (Util.stringNullOrEmpty((String)email)) continue;
            try {
                Email.enviar((Sessao)this.sessao, (String)email, (String)"", (String)assunto, (String)mensagem, (DataSource[])anexo, null, (boolean)true);
                ++numEmailsEnviados;
            }
            catch (UnicoMensagemUsuarioException ex) {
                throw new UnicoMensagemUsuarioException("YODA28", "Falha ao enviar o e-mail para '" + email + "'.", (Throwable)ex);
            }
        }
        if (numEmailsEnviados > 0) {
            this.getTask().setRetorno("E-mail(s) enviado(s) com sucesso.");
        }
    }

    public boolean isAtivo() {
        return !this.getCronExpression().isEmpty() && (LicencaManager.getInstance().isUniNfcePlus(this.sessao.getFilial().getCnpj()) || LicencaManager.getInstance().isUninfce());
    }

    public String getCronExpression() {
        return this.toDailyCron(PropriedadeRN.getInstance().getPropriedadeString(this.sessao.getFilial(), 740));
    }

    protected boolean isExecutarNoServidorSecundario() {
        return false;
    }
}

