/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.pdv;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.ConfiguracaoScanntech;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoScanntechCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.pdv.promocaoscanntech.download.CargaPromocoesScanntech;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.util.List;

public class ScanntechScheduler
extends RecurringYodaJob {
    private ConfiguracaoScanntech configuracao = ConfiguracaoScanntechCommonRN.getInstance().buscar(true);

    public ScanntechScheduler() {
        super(Cron.hourly(), TipoJob.SCANNTECH_CARGA_PROMOCAO_YODA);
        this.setCronConfiguradoTelaEspecifica(true);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        if (this.configuracao == null) {
            this.configuracao = ConfiguracaoScanntechCommonRN.getInstance().buscarConfiguracaoValida();
        }
        if (this.configuracao != null && ConfiguracaoScanntechCommonRN.getInstance().podeFazerCarga(this.configuracao)) {
            Sessao sessao = Sessao.createSessao();
            List filiais = FilialRN.getInstance().getFiliaisAtivaScantech();
            new CargaPromocoesScanntech(sessao, this.configuracao, filiais).fazerCarga();
        }
    }

    public boolean isAtivo() {
        return FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SCANNTECH);
    }

    public String getCronExpression() {
        return Cron.hourly();
    }
}

