/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.pdv;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.EventoSistema;
import br.intelidata.commons.domain.pojo.enuns.CategoriaEventoSistema;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.ReducaoZCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EventoSistemaRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.time.LocalDate;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;

public class ValidaReducaoZScheduler
extends RecurringYodaJob {
    private Sessao sessao = Contexto.getInstance().getSessao();

    public ValidaReducaoZScheduler() {
        super(Cron.daily((int)3), TipoJob.VALIDAR_REDUCAOZ_YODA);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        LocalDate hoje = DataHoraFactory.getData();
        LocalDate dataFinal = hoje.minusDays(2L);
        LocalDate dataInicio = dataFinal.minusDays(7L);
        HashMap reducaoZ = ReducaoZCommonRN.getInstance().buscarReducoesZFaltantes(dataInicio, dataFinal, this.sessao.getFilial().getCodigo());
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : reducaoZ.entrySet()) {
            sb.append("N\u00e3o foi localizado a redu\u00e7\u00e3o Z da ECF: ").append((String)entry.getValue()).append(", do dia: ").append(Util.formataDataHora((Temporal)((Temporal)entry.getKey()), (String)"dd/MM/yyyy")).append("! Verifique.\n");
        }
        if (sb.length() > 0) {
            String pendencias = sb.toString();
            this.getTask().setRetorno(pendencias);
            this.getIncluirEventoSistema(pendencias);
        } else {
            this.getTask().setRetorno("Sem pend\u00eancias.");
        }
    }

    private void getIncluirEventoSistema(String descricao) throws UnicoMensagemUsuarioException {
        EventoSistema evento = new EventoSistema();
        evento.setAvisar(true);
        evento.setCategoria(CategoriaEventoSistema.REDUCAO_Z);
        evento.setMillis(Long.valueOf(System.currentTimeMillis()));
        evento.setDescricao(descricao);
        EventoSistemaRN.getInstance().incluir((AbstractPojo)evento, this.sessao);
    }
}

