/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.retaguarda;

import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.DocumentoFiscalXml;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.enuns.TipoOrigemDocumentoFiscal;
import br.intelidata.commons.modulo.notafiscal.regranegocio.DocumentoFiscalXmlRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import br.intelidata.yoda.app.batch.retaguarda.ExportaDocumentoXMLScheduler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExportaDocumentoXMLScheduler
extends RecurringYodaJob {
    public ExportaDocumentoXMLScheduler() {
        super(Cron.every5minutes(), TipoJob.EXPORTAR_DOCUMENTO_XML_YODA);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        Map dirFiliais = this.getDiretoriosFiliais();
        if (dirFiliais.isEmpty()) {
            throw new UnicoMensagemUsuarioException("YODA31", "N\u00e3o foi configurado os diret\u00f3rio de exporta\u00e7\u00e3o para as filiais");
        }
        List documentoFiscalXmls = DocumentoFiscalXmlRN.getInstance().buscarDocumentosNaoExportados(new ArrayList(dirFiliais.keySet()));
        for (DocumentoFiscalXml documentoFiscalXml : documentoFiscalXmls) {
            this.exportar(documentoFiscalXml, this.getArquivo(documentoFiscalXml, dirFiliais));
        }
        this.getTask().setRetorno("Documentos exportados: " + documentoFiscalXmls.size());
    }

    public boolean isAtivo() {
        return FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.EXPORTAR_DOCUMENTO_XML);
    }

    private void exportar(DocumentoFiscalXml dfx, File arquivo) throws UnicoMensagemUsuarioException {
        this.log.info("Exportando arquivo {}", (Object)arquivo);
        try (FileOutputStream fos = new FileOutputStream(arquivo);){
            fos.write(dfx.getXml());
        }
        catch (IOException e) {
            throw new UnicoException("COM23669764", (Throwable)e);
        }
        dfx.setExportado(true);
        DocumentoFiscalXmlRN.getInstance().alterar((AbstractPojo)dfx, Sessao.createSessao((Long)dfx.getIdFilial()));
    }

    private File getArquivo(DocumentoFiscalXml dfx, Map<Long, File> dirFiliais) {
        File dir = dirFiliais.get(dfx.getIdFilial());
        if (!dir.exists()) {
            Util.criarDiretorio((File)dir);
        }
        return new File(dir, this.getNomeArquivo(dfx));
    }

    private String getNomeArquivo(DocumentoFiscalXml dfx) {
        String nomeArquivo = "";
        switch (1.$SwitchMap$br$intelidata$commons$domain$pojo$enuns$EventoDocumentoFiscal[dfx.getEvento().ordinal()]) {
            case 1: 
            case 2: {
                if (dfx.getOrigem().in(new AbstractEnum[]{TipoOrigemDocumentoFiscal.NFCE, TipoOrigemDocumentoFiscal.NFE})) {
                    nomeArquivo = dfx.getChave() + "-procNFe.xml";
                    break;
                }
                if (dfx.getOrigem() == TipoOrigemDocumentoFiscal.NFSE) {
                    nomeArquivo = dfx.getChave() + "-nfse.xml";
                    break;
                }
                if (dfx.getOrigem() == TipoOrigemDocumentoFiscal.CTE) {
                    nomeArquivo = dfx.getChave() + "-procCTe.xml";
                    break;
                }
                if (dfx.getOrigem() == TipoOrigemDocumentoFiscal.MDFE) {
                    nomeArquivo = dfx.getChave() + "-procMDFe.xml";
                    break;
                }
                if (!dfx.getOrigem().in(new AbstractEnum[]{TipoOrigemDocumentoFiscal.CARTA_CORRECAO_NFE, TipoOrigemDocumentoFiscal.CARTA_CORRECAO_CTE})) break;
                nomeArquivo = dfx.getChave() + "-CCE" + Util.zeroEsquerda((Object)dfx.getSequenciaEvento(), (int)2) + ".xml";
                break;
            }
            case 3: {
                nomeArquivo = dfx.getChave() + "-canc.xml";
                break;
            }
            case 4: {
                if (dfx.getOrigem() == TipoOrigemDocumentoFiscal.NFE_ENTRADA) {
                    nomeArquivo = dfx.getChave() + "-procNFe.xml";
                    break;
                }
                if (dfx.getOrigem() != TipoOrigemDocumentoFiscal.CTE_ENTRADA) break;
                nomeArquivo = dfx.getChave() + "-procCTe.xml";
                break;
            }
            case 5: {
                nomeArquivo = dfx.getChave() + "-enc.xml";
                break;
            }
            case 6: {
                nomeArquivo = dfx.getChave() + "-condutor" + Util.zeroEsquerda((Object)dfx.getSequenciaEvento(), (int)2) + ".xml";
                break;
            }
            case 7: {
                nomeArquivo = dfx.getChave() + "-inut.xml";
            }
        }
        if (Util.stringNullOrEmpty((String)nomeArquivo)) {
            throw new UnicoException("YODA22", "O evento " + dfx.getEvento().getDescricao() + " n\u00e3o foi mapeado");
        }
        return nomeArquivo;
    }

    private Map<Long, File> getDiretoriosFiliais() {
        HashMap<Long, File> dirFiliais = new HashMap<Long, File>();
        USelect uSql = new USelect("filial");
        uSql.add(new ColunaSQL("id"));
        uSql.add(new ColunaSQL("cnpj"));
        Sql sql = new Sql(uSql);
        sql.executaQuery();
        while (sql.next()) {
            Long idFilial = sql.getLong("id");
            String dir = (String)PropriedadeRN.getInstance().getPropriedade(idFilial, 863);
            if (Util.stringNullOrEmpty((String)dir)) continue;
            dirFiliais.put(idFilial, new File(dir, Util.apenasNumeros((String)sql.getString("cnpj"))));
        }
        sql.close();
        return dirFiliais;
    }
}

