/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.retaguarda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.Agendamento;
import br.intelidata.commons.domain.pojo.Empresa;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TarefaAgendamento;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.integracao.ControllerBI;
import br.intelidata.commons.modulo.cadastros.regranegocio.EmpresaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.ferramentas.agendamento.regranegocio.AgendamentoRN;
import br.intelidata.commons.modulo.integracao.integracaomercafacil.regranegocio.ControllerBIRN;
import br.intelidata.commons.modulo.integracao.integracaomercafacil.regranegocio.IntegracaoMercaFacilRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.time.LocalDate;
import java.util.List;

public class MercaFacilScheduler
extends RecurringYodaJob {
    private Sessao sessao = Contexto.getInstance().getSessao();
    private Agendamento agendamento;

    public MercaFacilScheduler() {
        super(Cron.daily((int)3), TipoJob.MERCAFACIL_YODA);
        this.setCronConfiguradoTelaEspecifica(true);
        this.agendamento = AgendamentoRN.getInstance().buscaAgendamento(TarefaAgendamento.MERCAFACIL.getId());
    }

    public void execute() throws UnicoMensagemUsuarioException {
        Empresa empresa = (Empresa)EmpresaRN.getInstance().buscarPorId(this.sessao.getFilial().getIdEmpresa());
        List filiais = FilialRN.getInstance().getFiliaisPorEmpresa(empresa.getId());
        List controles = ControllerBIRN.getInstance().buscaControlesPendentes((Long[])filiais.stream().map(Filial::getId).toArray(Long[]::new));
        if (!Util.listNullOrEmpty((List)controles)) {
            for (ControllerBI controllerBI : controles) {
                this.iniciaIntegracao(empresa, filiais, controllerBI.getData());
            }
        }
        ControllerBIRN.getInstance().atualizaControles(this.sessao, controles);
    }

    private void iniciaIntegracao(Empresa empresa, List<Filial> filiais, LocalDate data) throws UnicoMensagemUsuarioException {
        String diretorio = PropriedadeRN.getInstance().getPropriedadeString(this.sessao.getFilial(), 435);
        IntegracaoMercaFacilRN.getInstance().gerarIntegracao(diretorio, empresa, filiais, data, data);
    }

    public boolean isAtivo() {
        return this.agendamento != null && !Util.stringNullOrEmpty((String)this.agendamento.getHoras());
    }

    public String getCronExpression() {
        return AgendamentoRN.getInstance().getExpressaoCron(this.agendamento, "0");
    }
}

