/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.retaguarda;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.InativoFilial;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.preco.regranegocio.ProgramacaoAlteracaoPrecoRN;
import br.intelidata.yoda.app.batch.RecurringYodaJob;
import java.util.List;

public class ProgramacaoPrecoScheduler
extends RecurringYodaJob {
    private Sessao sessao = Contexto.getInstance().getSessao();

    public ProgramacaoPrecoScheduler() {
        super(Cron.daily((int)3), TipoJob.PROMOCAO_PRECO_YODA);
        this.setCronConfiguradoTelaEspecifica(true);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        List filiais = FilialRN.getInstance().buscarLista();
        StringBuilder codigosFiliais = new StringBuilder();
        for (Filial filial : filiais) {
            if (filial.getInativo() != InativoFilial.NAO || !PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 348) || !PropriedadeRN.getInstance().getPropriedadeBoolean(filial, 349)) continue;
            codigosFiliais.append(codigosFiliais.length() > 0 ? ", " : "").append(filial.getCodigo());
        }
        if (!Util.listNullOrEmpty((List)ProgramacaoAlteracaoPrecoRN.getInstance().buscarProgramacaoAlteracaoAutomatica(DataHoraFactory.getData()))) {
            ProgramacaoAlteracaoPrecoRN.getInstance().aplicaAlteracaoPrecoAutomatica(this.sessao, DataHoraFactory.getData());
        }
    }

    public boolean isAtivo() {
        return !this.getCronExpression().isEmpty() && ProgramacaoAlteracaoPrecoRN.getInstance().isLiberacaoAutomaticaPrecoHabilitada();
    }

    public String getCronExpression() {
        return this.toDailyCron(PropriedadeRN.getInstance().getPropriedadeString(this.sessao.getFilial(), 865));
    }
}

