/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.batch.sistema;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.importacao.ImportacaoLeituraArquivo;
import br.intelidata.commons.modulo.r2d2.R2D2Manager;
import br.intelidata.yoda.app.batch.RecurringYodaJob;

public class R2D2Scheduler
extends RecurringYodaJob {
    private static final R2D2Manager r2d2 = new R2D2Manager();
    private Sessao sessao = Contexto.getInstance().getSessao();

    public R2D2Scheduler() {
        super(Cron.every15seconds(), TipoJob.R2D2_YODA);
    }

    public void execute() throws UnicoMensagemUsuarioException {
        if (!r2d2.isConfigurado()) {
            r2d2.inicializarArquivos();
            r2d2.configuraR2D2(new ImportacaoLeituraArquivo());
        }
        r2d2.inicializarVariaveis();
        r2d2.importa(this.sessao);
        r2d2.exporta();
        this.getTask().setRetorno(r2d2.getMensagemRetorno());
        if (r2d2.getErrosLayout() != null) {
            throw new UnicoMensagemUsuarioException("R2D2183", "Erro de layout");
        }
    }

    public void onFailure(Exception ex) {
        if (r2d2.getErrosLayout() != null) {
            this.getTask().setPrintStack(r2d2.getErrosLayout().toString());
        }
    }

    public String getCronExpression() {
        return Cron.every15seconds();
    }

    public boolean isAtivo() {
        return ModuloManager.getInstance().isAtivo(Modulo.R2D2);
    }

    protected boolean isExecutarNoServidorSecundario() {
        return false;
    }
}

