/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.cte;

import br.intelidata.commons.core.documentosfiscais.common.pojo.remoto.ConsultaDataCertificado;
import br.intelidata.commons.core.documentosfiscais.common.pojo.remoto.PojoRemoto;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.cte3.TransmissorCte3;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.cte3.TransmissorCte3Local;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.RetornoConsultaReciboCTe;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.RetornoConsultaSituacaoCTe;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.RetornoConsultaStatusServicoCTE;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.RetornoEnvioCTe;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.RetornoEventoCTE;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.RetornoInutilizacaoCTe;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.remoto.CancelarCteRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.remoto.CartaCorrecaoCteRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.remoto.ConsultaCteRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.remoto.ConsultaStatusReciboCteRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.remoto.ConsultaStatusServicoCteRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.remoto.ContingenciaEPECCteRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.remoto.InutilizarCteRequest;
import br.intelidata.commons.core.documentosfiscais.sefaz.cte.pojo.remoto.ProcessarCteRequest;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cte3/"})
public class Cte3Controller {
    @RequestMapping(value={"statusServico"})
    @DBAutoCommit
    public RetornoConsultaStatusServicoCTE statusServico(@RequestBody ConsultaStatusServicoCteRequest request) throws Exception {
        TransmissorCte3 transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.getStatusServico();
    }

    @RequestMapping(value={"processar"})
    @DBAutoCommit
    public RetornoEnvioCTe enviarLote(@RequestBody ProcessarCteRequest request) throws Exception {
        TransmissorCte3 transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.processar(request.getNroLote(), request.getCteXML(), request.getFormaEmissao(), request.isRemoverQuebraLinhaAssinaCte());
    }

    @RequestMapping(value={"statusRecibo"})
    @DBAutoCommit
    public RetornoConsultaReciboCTe consultarRecibo(@RequestBody ConsultaStatusReciboCteRequest request) throws Exception {
        TransmissorCte3 transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.getStatusRecibo(request.getNumeroRecibo(), request.getFormaEmissao());
    }

    @RequestMapping(value={"cancelar"})
    @DBAutoCommit
    public RetornoEventoCTE cancelar(@RequestBody CancelarCteRequest request) throws Exception {
        TransmissorCte3 transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.cancelar(request.getCnpj(), request.getChaveCTe(), request.getProtocolo(), request.getJustificativa());
    }

    @RequestMapping(value={"cartaCorrecao"})
    @DBAutoCommit
    public RetornoEventoCTE cartaCorrecao(@RequestBody CartaCorrecaoCteRequest request) throws Exception {
        TransmissorCte3 transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.transmitirCartaCorrecao(request.getCnpj(), request.getChaveCTe(), request.getDataEvento(), request.getEvento(), request.getSequencia());
    }

    @RequestMapping(value={"consultar"})
    @DBAutoCommit
    public RetornoConsultaSituacaoCTe consultar(@RequestBody ConsultaCteRequest request) throws Exception {
        TransmissorCte3 transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.consultar(request.getChave());
    }

    @RequestMapping(value={"inutilizar"})
    @DBAutoCommit
    public RetornoInutilizacaoCTe incluirCondutor(@RequestBody InutilizarCteRequest request) throws Exception {
        TransmissorCte3 transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.inutilizar(request.getJustificativa(), request.getAno(), request.getCnpj(), request.getModelo(), request.getSerie(), request.getnNFIni(), request.getnNFFin());
    }

    @RequestMapping(value={"contingenciaEPEC"})
    @DBAutoCommit
    public RetornoEventoCTE contingenciaEPEC(@RequestBody ContingenciaEPECCteRequest request) throws Exception {
        TransmissorCte3 transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return transmissor.contingenciaEPEC(request.getCnpj(), request.getChaveCTe(), request.getDataEvento(), request.getJustificativa(), request.getIcms(), request.getValorServico(), request.getValorCarga(), request.getTipoTomador(), request.getUfTomador(), request.getCpfCnpjTomador(), request.getIeTomador(), request.getModal(), request.getUfInicio(), request.getUfFim(), request.getFormaEmissao());
    }

    @RequestMapping(value={"dataCertificado"})
    @DBAutoCommit
    public ConsultaDataCertificado dataCertificado(@RequestBody PojoRemoto request) throws Exception {
        TransmissorCte3 transmissor = this.getTransmissor(Long.valueOf(request.getIdFilial()));
        return new ConsultaDataCertificado(transmissor.getDataCertificado());
    }

    private TransmissorCte3 getTransmissor(Long idFilial) throws UnicoMensagemUsuarioException {
        Filial filial = (Filial)FilialRN.getInstance().buscarPorId(idFilial);
        return new TransmissorCte3Local(filial);
    }
}

