SELECT
  pessoa.id                                                                          codigo,
  pessoa.nome,
  juridica.nomefantasia,
  (SELECT documento.numero
   FROM documento
   WHERE documento.pessoaid = pessoa.id AND upper(trim(documento.tipo)) = 'CPF')     cpf,
  (SELECT documento.numero
   FROM documento
   WHERE documento.pessoaid = pessoa.id AND upper(trim(documento.tipo)) = 'CNPJ')    cnpj,
  (SELECT documento.numero
   FROM documento
   WHERE documento.pessoaid = pessoa.id AND upper(trim(documento.tipo)) = 'IE')      ie,
  (SELECT documento.numero
   FROM documento
   WHERE documento.pessoaid = pessoa.id AND upper(trim(documento.tipo)) = 'RG')      rg,
  endereco.cep,
  endereco.logradouro,
  endereco.numero,
  endereco.complemento,
  endereco.bairro,
  municipio.nome                                                                     cidade,
  uf.sigla                                                                           estado,
  (SELECT telefone.numero
   FROM telefone
   WHERE telefone.pessoaid = pessoa.id AND upper(trim(telefone.tipo)) = 'PRINCIPAL') telefone,
  (SELECT telefone.numero
   FROM telefone
   WHERE telefone.pessoaid = pessoa.id AND upper(trim(telefone.tipo)) = 'CELULAR')   celular,
  CASE WHEN pessoa.clienteid IS NOT NULL
    THEN
      1
  ELSE
    CASE WHEN pessoa.fornecedorid IS NOT NULL
      THEN
        2
    END
  END                                                                                tipo
FROM
  pessoa
  LEFT JOIN endereco ON pessoa.id = endereco.pessoaid
  LEFT JOIN municipio ON endereco.municipioid = municipio.id
  LEFT JOIN uf ON municipio.ufid = uf.id
  LEFT JOIN juridica ON pessoa.juridicaid = juridica.id
WHERE
  (pessoa.clienteid IS NOT NULL OR pessoa.fornecedorid IS NOT NULL)
  AND (pessoa.fisicaid IS NOT NULL OR pessoa.juridicaid IS NOT NULL)
