SELECT 
  produto.id_produto											codigo,
  produto.nome 													descricao,
  produto.referencia_interna_produto 							referencia,
  produto.situacao 												ativo,
  unidade_medida.sigla 											unidade,
  hierarquia_produto.nome 										grupo,
  produto.preco_custo 											precocusto,
  produto.preco_venda 											precovenda,
  ncm.id_ncm 													ncm,
  ncm.codigo_cest 												cest,
  situacao_tributaria_pis.codigo_situacao_tributaria_pis 		cstpissaida,
  produto.aliquota_pis 											aliquotapisentrada,
  produto.aliquota_pis 											aliquotapissaida,
  situacao_tributaria_pis.codigo_situacao_tributaria_pis 		cstcofinssaida,
  produto.aliquota_cofins 										aliquotacofinssaida,
  produto.aliquota_cofins 										aliquotacofinsentrada,
  produto.id_situacao_tributaria_ipi 							cstipisaida,
  produto.aliquota_ipi 											percentualipisaida,
  produto.origem_produto 										origem,
  produto.produto_integrado_balanca 							pesavel,
  produto.markup_varejo 										lucro,
  situacao_tributaria_icms.codigo_situacao_tributaria 			csticms,
  regra_tributacao_icms_personalizada.aliquota_icms 			aliquotaicms,
  ean.ean                                                       ean
FROM
  produto
  LEFT JOIN unidade_medida ON unidade_medida.id_unidade_medida = produto.id_unidade_medida
  LEFT JOIN hierarquia_produto ON hierarquia_produto.id_hierarquia_produto = produto.id_hierarquia_produto
  LEFT JOIN ncm ON ncm.id_ncm = produto.id_ncm
  LEFT JOIN regra_tributacao_icms_personalizada ON regra_tributacao_icms_personalizada.id_produto = produto.id_produto
  AND regra_tributacao_icms_personalizada.excluido = 0
  LEFT JOIN situacao_tributaria_icms ON situacao_tributaria_icms.id_situacao_tributaria_icms = regra_tributacao_icms_personalizada.id_situacao_tributaria_icms
  LEFT JOIN situacao_tributaria_pis ON situacao_tributaria_pis.id_situacao_tributaria_pis = produto.id_situacao_tributaria_pis
  LEFT JOIN
    (SELECT produto_sinonimo.id_produto, max(codigo_barras)		ean
  FROM produto_sinonimo
  left join produto on produto.id_produto = produto_sinonimo.id_produto
  WHERE produto.excluido = 0 and CONVERT(VARCHAR, produto.id_produto) <> codigo_barras
  GROUP BY
           produto_sinonimo.id_produto) as ean on ean.id_produto = produto.id_produto
WHERE
  produto.excluido = 0
