/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.yoda.app.atualizador.componentes;

import br.intelidata.yoda.app.atualizador.componentes.YodaTableModel;
import br.intelidata.yoda.app.atualizador.componentes.YodaTableModelColuna;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class YodaTable<E>
extends JTable {
    private YodaTableModel<E> modelo;

    public YodaTable(List<YodaTableModelColuna> colunas) {
        this.modelo = new YodaTableModel(colunas);
        this.configura();
    }

    private void configura() {
        this.setModel((TableModel)this.modelo);
        this.configurarColunas();
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "selectNextColumnCell");
        this.desativarAtalho();
    }

    public void configurarColunas() {
        for (int i = 0; i < this.modelo.getColunas().length; ++i) {
            YodaTableModelColuna coluna = this.modelo.getColunas()[i];
            this.getColumnModel().getColumn(i).setIdentifier(coluna.getNome());
            if (coluna.getTamanho() <= 0) continue;
            this.getColumnModel().getColumn(i).setPreferredWidth(coluna.getTamanho());
        }
    }

    private void desativarAtalho() {
        this.getActionMap().getParent().remove("focusHeader");
    }

    @Override
    public TableCellEditor getCellEditor(int linha, int coluna) {
        YodaTableModelColuna col;
        int colModel;
        if (this.modelo != null && (colModel = this.convertColumnIndexToModel(coluna)) >= 0 && (col = this.modelo.getColunas()[colModel]).getEditor() != null) {
            return col.getEditor();
        }
        return super.getCellEditor(linha, coluna);
    }

    @Override
    public TableCellRenderer getCellRenderer(int linha, int coluna) {
        YodaTableModelColuna col;
        int colModel;
        if (this.modelo != null && (colModel = this.convertColumnIndexToModel(coluna)) >= 0 && (col = this.modelo.getColunas()[colModel]).getRenderer() != null) {
            return col.getRenderer();
        }
        TableCellRenderer c = super.getCellRenderer(linha, coluna);
        if (c != null) {
            ((Component)((Object)c)).setBackground(Color.WHITE);
        }
        return super.getCellRenderer(linha, coluna);
    }

    public void setFonteDados(List<E> fonteDados) {
        this.modelo.setFonteDados(fonteDados);
    }

    public List<E> getFonteDados() {
        return this.modelo.getFonteDados();
    }

    public void fireTableDataChanged() {
        if (this.modelo != null) {
            this.modelo.fireTableDataChanged();
        }
    }

    public YodaTableModel<E> getModelo() {
        return this.modelo;
    }

    public void setModelo(YodaTableModel<E> modelo) {
        this.modelo = modelo;
        this.configura();
    }

    public Object getValorPorIdColuna(String id, int linha) {
        int coluna = this.getIndexColuna(id);
        if (coluna > -1) {
            return this.getValueAt(linha, coluna);
        }
        return null;
    }

    public int getIndexColuna(String id) {
        try {
            return this.getColumnModel().getColumnIndex(id);
        }
        catch (IllegalArgumentException ex) {
            return -1;
        }
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (column < 0 || column >= this.getColumnCount()) {
            return;
        }
        super.setValueAt(aValue, row, column);
    }

    public E getObjetoSelecionado() {
        if (this.getSelectedRow() > -1) {
            return (E)this.getModelo().get(this.getSelectedRow());
        }
        return null;
    }

    public E getObjeto(int index) {
        if (index > -1 && index < this.getRowCount()) {
            return (E)this.getModelo().get(index);
        }
        return null;
    }

    public E remover(int index) {
        Object obj = null;
        if (index < this.getRowCount()) {
            obj = this.getObjeto(index);
            this.getModelo().remove(index);
            this.getModelo().fireTableDataChanged();
        }
        return (E)obj;
    }

    public void remover(E objeto) {
        this.getModelo().getFonteDados().remove(objeto);
        this.getModelo().fireTableDataChanged();
    }

    public void posicionaSelecaoNaLinha(int linha) {
        if (linha == -1) {
            linha = this.getModelo().getFonteDados().size() - 1;
        }
        this.scrollRectToVisible(this.getCellRect(linha, 0, true));
    }

    public void adicionarOuAtualizar(E objeto) {
        int idx = this.getModelo().getFonteDados().indexOf(objeto);
        if (idx > -1) {
            this.atualizar(idx, objeto);
        } else {
            this.adicionar(objeto);
        }
    }

    public void adicionar(E objeto) {
        this.adicionar(-1, objeto);
    }

    public void adicionar(int index, E objeto) {
        this.getModelo().add(index, objeto);
        this.getModelo().fireTableDataChanged();
        this.posicionaSelecaoNaLinha(index);
    }

    public void atualizar(int index, E objeto) {
        this.getModelo().set(index, objeto);
        this.getModelo().fireTableDataChanged();
    }

    public void excluirItemSelecionado() {
        int idxItem = this.getSelectedRow();
        if (idxItem > -1) {
            this.getFonteDados().remove(idxItem);
            this.fireTableDataChanged();
        }
    }

    public void limpar() {
        this.getFonteDados().clear();
        this.fireTableDataChanged();
    }
}

